/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.ultraman.store;

import com.google.common.base.CaseFormat;
import com.xforceplus.general.ultraman.DataStoreFacade;
import com.xforceplus.general.ultraman.store.UltramanDataStoreFacadeWrapper;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.domain.vo.Page;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import io.vavr.Tuple2;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractDataStoreAdapter<T>
implements DataStoreFacade<T>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataStoreAdapter.class);
    private ApplicationContext context;
    private UltramanDataStoreFacadeWrapper businessFacadeWrapper;
    private String entityCode;
    private Class<T> targetClass;

    public AbstractDataStoreAdapter() {
        ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.targetClass = (Class)pt.getActualTypeArguments()[0];
        this.entityCode = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.targetClass.getSimpleName());
    }

    public IEntityClass entityClass() {
        return this.businessFacadeWrapper.load(this.entityCode);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.businessFacadeWrapper = (UltramanDataStoreFacadeWrapper)this.context.getBean(UltramanDataStoreFacadeWrapper.class);
    }

    @Override
    public Long countAll() {
        return this.businessFacadeWrapper.countAll(this.entityClass());
    }

    @Override
    public Long count(ConditionQueryRequest request) {
        return this.businessFacadeWrapper.count(this.entityClass(), request);
    }

    @Override
    public Long count(ExpQuery query) {
        return this.businessFacadeWrapper.count(this.entityClass(), query);
    }

    @Override
    public Long insert(Map<String, Object> value) {
        return this.businessFacadeWrapper.insert(this.entityClass(), value);
    }

    @Override
    public Long insert(T model) {
        return this.businessFacadeWrapper.insert(this.entityClass(), model);
    }

    @Override
    public Long insert(T model, Map<String, Object> extValue) {
        return this.businessFacadeWrapper.insert(this.entityClass(), model, extValue);
    }

    @Override
    public Integer insertBatch(List<T> models) {
        return this.businessFacadeWrapper.insertBatch(this.entityClass(), models);
    }

    @Override
    public Integer insertBatchMap(List<Map<String, Object>> values) {
        return this.businessFacadeWrapper.insertBatchMap(this.entityClass(), values);
    }

    @Override
    public Integer deleteById(Long id) {
        return this.businessFacadeWrapper.deleteById(this.entityClass(), id);
    }

    @Override
    public Integer deleteBatch(List<Long> ids) {
        return this.businessFacadeWrapper.deleteBatch(this.entityClass(), ids);
    }

    @Override
    public Integer deleteOneByKeys(Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.deleteOneByKeys(this.entityClass(), keyValues);
    }

    @Override
    public Integer deleteByCondition(ConditionQueryRequest request) {
        return this.businessFacadeWrapper.deleteByCondition(this.entityClass(), request);
    }

    @Override
    public Integer deleteByCondition(ExpQuery query) {
        return this.businessFacadeWrapper.deleteByCondition(this.entityClass(), query);
    }

    @Override
    public Integer deleteBatchByCondition(ConditionQueryRequest request) {
        return this.businessFacadeWrapper.deleteBatchByCondition(this.entityClass(), ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @Override
    public Integer deleteBatchByCondition(ExpQuery query) {
        return this.businessFacadeWrapper.deleteBatchByCondition(this.entityClass(), query);
    }

    @Override
    public Integer updateById(T model) {
        return this.businessFacadeWrapper.updateById(this.entityClass(), model);
    }

    @Override
    public Integer updateById(Map<String, Object> value, Long id) {
        return this.businessFacadeWrapper.updateById(this.entityClass(), value, id);
    }

    @Override
    public Integer updateBatch(List<T> models) {
        return this.businessFacadeWrapper.updateBatch(this.entityClass(), models);
    }

    @Override
    public Integer updateBatchMap(List<Map<String, Object>> values) {
        return this.businessFacadeWrapper.updateBatchMap(this.entityClass(), values);
    }

    @Override
    public Integer updateByKeys(Map<String, Object> value, Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.updateByKeys(this.entityClass(), value, keyValues);
    }

    @Override
    public List<T> findAllWithoutPageAndSort(ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findAllWithoutPageAndSort(this.entityClass(), this.targetClass, request);
    }

    @Override
    public List<T> findAllWithoutPageAndSort(ExpQuery expQuery) {
        return this.businessFacadeWrapper.findAllWithoutPageAndSort(this.entityClass(), this.targetClass, expQuery);
    }

    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findAllMapWithoutPageAndSort(this.entityClass(), request);
    }

    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(ExpQuery expQuery) {
        return this.businessFacadeWrapper.findAllMapWithoutPageAndSort(this.entityClass(), expQuery);
    }

    @Override
    public Page<T> findPageByCondition(ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findPageByCondition(this.entityClass(), this.targetClass, ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @Override
    public Page<T> findPageByCondition(ExpQuery query) {
        return this.businessFacadeWrapper.findPageByCondition(this.entityClass(), this.targetClass, query);
    }

    @Override
    public Page<Map<String, Object>> findPageMapByCondition(ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findPageMapByCondition(this.entityClass(), request);
    }

    @Override
    public Page<Map<String, Object>> findPageMapByCondition(ExpQuery query) {
        return this.businessFacadeWrapper.findPageMapByCondition(this.entityClass(), query);
    }

    @Override
    public List<T> findByCondition(ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findByCondition(this.entityClass(), this.targetClass, request);
    }

    @Override
    public List<T> findByCondition(ExpQuery expQuery) {
        return this.businessFacadeWrapper.findByCondition(this.entityClass(), this.targetClass, expQuery);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findByConditionMap(this.entityClass(), request);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(ExpQuery expQuery) {
        return this.businessFacadeWrapper.findByConditionMap(this.entityClass(), expQuery);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(IEntityClass entityClass, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findCollectionMapByCondition(entityClass, request);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(IEntityClass entityClass, ExpRel expRel) {
        return this.businessFacadeWrapper.findCollectionMapByCondition(entityClass, expRel);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByIds(IEntityClass entityClass, List<Long> ids) {
        return this.businessFacadeWrapper.findCollectionMapByIds(entityClass, ids);
    }

    @Override
    public T findOneById(Long id) {
        return this.businessFacadeWrapper.findOneById(this.entityClass(), this.targetClass, id);
    }

    @Override
    public Map<String, Object> findOneMapById(Long id) {
        return this.businessFacadeWrapper.findOneMapById(this.entityClass(), id);
    }

    @Override
    public T findOneByKeys(Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.findOneByKeys(this.entityClass(), this.targetClass, keyValues);
    }

    @Override
    public Map<String, Object> findOneMapByKeys(Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.findOneMapByKeys(this.entityClass(), keyValues);
    }
}

