/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.grayrelease.plugin.feign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;

public class FeignConfig {
    Boolean enabled = false;
    Map<String, RouteConfig> routeConfigList;
    DoubleMode doubleMode = new DoubleMode();

    public void setRouteConfigList(List<RouteConfig> routeConfigList) {
        this.routeConfigList = routeConfigList.stream().collect(Collectors.toMap(RouteConfig::getSourceRoutePath, v -> v));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Map<String, RouteConfig> getRouteConfigList() {
        return this.routeConfigList;
    }

    public DoubleMode getDoubleMode() {
        return this.doubleMode;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setDoubleMode(DoubleMode doubleMode) {
        this.doubleMode = doubleMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeignConfig)) {
            return false;
        }
        FeignConfig other = (FeignConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Map<String, RouteConfig> this$routeConfigList = this.getRouteConfigList();
        Map<String, RouteConfig> other$routeConfigList = other.getRouteConfigList();
        if (this$routeConfigList == null ? other$routeConfigList != null : !((Object)this$routeConfigList).equals(other$routeConfigList)) {
            return false;
        }
        DoubleMode this$doubleMode = this.getDoubleMode();
        DoubleMode other$doubleMode = other.getDoubleMode();
        return !(this$doubleMode == null ? other$doubleMode != null : !((Object)this$doubleMode).equals(other$doubleMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeignConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Map<String, RouteConfig> $routeConfigList = this.getRouteConfigList();
        result = result * 59 + ($routeConfigList == null ? 43 : ((Object)$routeConfigList).hashCode());
        DoubleMode $doubleMode = this.getDoubleMode();
        result = result * 59 + ($doubleMode == null ? 43 : ((Object)$doubleMode).hashCode());
        return result;
    }

    public String toString() {
        return "FeignConfig(enabled=" + this.getEnabled() + ", routeConfigList=" + this.getRouteConfigList() + ", doubleMode=" + this.getDoubleMode() + ")";
    }

    public static class RouteConfig {
        @NotEmpty
        String sourceRoutePath;
        @NotEmpty
        String targetRoutePath;
        Set<Long> tenantIdList;
        Set<String> tenantCodeList;

        public void setTenantIdList(String tenantIdList) {
            this.tenantIdList = Arrays.asList(tenantIdList.split(",")).stream().map(item -> Long.valueOf(item)).collect(Collectors.toSet());
        }

        public void setTenantCodeList(String tenantCodeList) {
            this.tenantCodeList = Arrays.asList(tenantCodeList.split(",")).stream().collect(Collectors.toSet());
        }

        public String getSourceRoutePath() {
            return this.sourceRoutePath;
        }

        public String getTargetRoutePath() {
            return this.targetRoutePath;
        }

        public Set<Long> getTenantIdList() {
            return this.tenantIdList;
        }

        public Set<String> getTenantCodeList() {
            return this.tenantCodeList;
        }

        public void setSourceRoutePath(String sourceRoutePath) {
            this.sourceRoutePath = sourceRoutePath;
        }

        public void setTargetRoutePath(String targetRoutePath) {
            this.targetRoutePath = targetRoutePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RouteConfig)) {
                return false;
            }
            RouteConfig other = (RouteConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sourceRoutePath = this.getSourceRoutePath();
            String other$sourceRoutePath = other.getSourceRoutePath();
            if (this$sourceRoutePath == null ? other$sourceRoutePath != null : !this$sourceRoutePath.equals(other$sourceRoutePath)) {
                return false;
            }
            String this$targetRoutePath = this.getTargetRoutePath();
            String other$targetRoutePath = other.getTargetRoutePath();
            if (this$targetRoutePath == null ? other$targetRoutePath != null : !this$targetRoutePath.equals(other$targetRoutePath)) {
                return false;
            }
            Set<Long> this$tenantIdList = this.getTenantIdList();
            Set<Long> other$tenantIdList = other.getTenantIdList();
            if (this$tenantIdList == null ? other$tenantIdList != null : !((Object)this$tenantIdList).equals(other$tenantIdList)) {
                return false;
            }
            Set<String> this$tenantCodeList = this.getTenantCodeList();
            Set<String> other$tenantCodeList = other.getTenantCodeList();
            return !(this$tenantCodeList == null ? other$tenantCodeList != null : !((Object)this$tenantCodeList).equals(other$tenantCodeList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RouteConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourceRoutePath = this.getSourceRoutePath();
            result = result * 59 + ($sourceRoutePath == null ? 43 : $sourceRoutePath.hashCode());
            String $targetRoutePath = this.getTargetRoutePath();
            result = result * 59 + ($targetRoutePath == null ? 43 : $targetRoutePath.hashCode());
            Set<Long> $tenantIdList = this.getTenantIdList();
            result = result * 59 + ($tenantIdList == null ? 43 : ((Object)$tenantIdList).hashCode());
            Set<String> $tenantCodeList = this.getTenantCodeList();
            result = result * 59 + ($tenantCodeList == null ? 43 : ((Object)$tenantCodeList).hashCode());
            return result;
        }

        public String toString() {
            return "FeignConfig.RouteConfig(sourceRoutePath=" + this.getSourceRoutePath() + ", targetRoutePath=" + this.getTargetRoutePath() + ", tenantIdList=" + this.getTenantIdList() + ", tenantCodeList=" + this.getTenantCodeList() + ")";
        }
    }

    public static class DoubleMode {
        Boolean enabled = false;
        Integer corePoolSize = 5;
        Integer maximumPoolSize = 50;
        Long keepAliveTime = 60L;
        List<String> apiList = new ArrayList<String>();

        public Boolean getEnabled() {
            return this.enabled;
        }

        public Integer getCorePoolSize() {
            return this.corePoolSize;
        }

        public Integer getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public Long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public List<String> getApiList() {
            return this.apiList;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public void setCorePoolSize(Integer corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaximumPoolSize(Integer maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public void setKeepAliveTime(Long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setApiList(List<String> apiList) {
            this.apiList = apiList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DoubleMode)) {
                return false;
            }
            DoubleMode other = (DoubleMode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            Integer this$corePoolSize = this.getCorePoolSize();
            Integer other$corePoolSize = other.getCorePoolSize();
            if (this$corePoolSize == null ? other$corePoolSize != null : !((Object)this$corePoolSize).equals(other$corePoolSize)) {
                return false;
            }
            Integer this$maximumPoolSize = this.getMaximumPoolSize();
            Integer other$maximumPoolSize = other.getMaximumPoolSize();
            if (this$maximumPoolSize == null ? other$maximumPoolSize != null : !((Object)this$maximumPoolSize).equals(other$maximumPoolSize)) {
                return false;
            }
            Long this$keepAliveTime = this.getKeepAliveTime();
            Long other$keepAliveTime = other.getKeepAliveTime();
            if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
                return false;
            }
            List<String> this$apiList = this.getApiList();
            List<String> other$apiList = other.getApiList();
            return !(this$apiList == null ? other$apiList != null : !((Object)this$apiList).equals(other$apiList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DoubleMode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            Integer $corePoolSize = this.getCorePoolSize();
            result = result * 59 + ($corePoolSize == null ? 43 : ((Object)$corePoolSize).hashCode());
            Integer $maximumPoolSize = this.getMaximumPoolSize();
            result = result * 59 + ($maximumPoolSize == null ? 43 : ((Object)$maximumPoolSize).hashCode());
            Long $keepAliveTime = this.getKeepAliveTime();
            result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
            List<String> $apiList = this.getApiList();
            result = result * 59 + ($apiList == null ? 43 : ((Object)$apiList).hashCode());
            return result;
        }

        public String toString() {
            return "FeignConfig.DoubleMode(enabled=" + this.getEnabled() + ", corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", keepAliveTime=" + this.getKeepAliveTime() + ", apiList=" + this.getApiList() + ")";
        }
    }
}

