/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.grayrelease.plugin.feign;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.xforceplus.purchaser.grayrelease.plugin.GrayReleaseConfig;
import com.xforceplus.purchaser.grayrelease.plugin.SSLSocketClient;
import com.xforceplus.purchaser.grayrelease.plugin.TenantInfoHolder;
import com.xforceplus.purchaser.grayrelease.plugin.feign.FeignConfig;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GrayReleaseFeignInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(GrayReleaseFeignInterceptor.class);
    GrayReleaseConfig config;
    String sourceRoutePath;
    Executor executor;
    OkHttpClient client;

    public GrayReleaseFeignInterceptor(GrayReleaseConfig config, String sourceRoutePath) {
        if (config != null) {
            this.config = config;
        }
        if (this.config == null) {
            this.config = new GrayReleaseConfig();
        }
        log.info("init GrayReleaseFeignInterceptor " + sourceRoutePath);
        log.info("GrayReleaseFeignInterceptor config:{}", (Object)this.config);
        this.sourceRoutePath = sourceRoutePath;
        this.executor = TtlExecutors.getTtlExecutor((Executor)new ThreadPoolExecutor(this.config.getFeign().getDoubleMode().getCorePoolSize(), this.config.getFeign().getDoubleMode().getMaximumPoolSize(), this.config.getFeign().getDoubleMode().getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy()));
        this.client = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).sslSocketFactory(SSLSocketClient.getSSLSocketFactory(), SSLSocketClient.getX509TrustManager()).hostnameVerifier(SSLSocketClient.getHostnameVerifier()).build();
    }

    public void apply(RequestTemplate template) {
        if (this.config == null || !Boolean.TRUE.equals(this.config.getFeign().getEnabled())) {
            return;
        }
        String targetRoutePath = this.matchRoutePath();
        this.invokeDouble(targetRoutePath, template);
        if (targetRoutePath != null) {
            String sourceRoutePath = this.config.getFeign().getRouteConfigList().get(this.sourceRoutePath).getSourceRoutePath();
            String substring = template.url().substring(template.url().indexOf(sourceRoutePath) + sourceRoutePath.length());
            template.uri(targetRoutePath + substring, false);
        }
    }

    public void invokeDouble(String targetRoutePathMatched, RequestTemplate template) {
        if (!this.config.getFeign().getDoubleMode().getEnabled().booleanValue()) {
            return;
        }
        if (template.method().toLowerCase().equals("get")) {
            return;
        }
        List<String> apiList = this.config.getFeign().getDoubleMode().getApiList();
        if (CollectionUtils.isEmpty(apiList)) {
            return;
        }
        Optional<String> any = apiList.stream().filter(api -> template.url().contains((CharSequence)api)).findAny();
        if (!any.isPresent()) {
            return;
        }
        String url = template.url();
        if (targetRoutePathMatched == null) {
            FeignConfig.RouteConfig routeConfig = this.config.getFeign().getRouteConfigList().get(this.sourceRoutePath);
            if (routeConfig == null) {
                return;
            }
            url = url.replace(routeConfig.getSourceRoutePath(), routeConfig.getTargetRoutePath());
        }
        String finalUrl = template.feignTarget().url() + url;
        this.executor.execute(() -> {
            log.info("invokeDouble request url:{}", (Object)finalUrl);
            String method = template.method();
            String body = template.requestBody().asString();
            Headers.Builder headersBuilder = new Headers.Builder();
            template.headers().forEach((k, v) -> headersBuilder.add(k, (String)v.iterator().next()));
            Headers headers = headersBuilder.build();
            Request request = new Request.Builder().url(finalUrl).method(method, body == null ? null : RequestBody.create((String)body, (MediaType)MediaType.parse((String)"application/json"))).headers(headers).build();
            try (Response response = this.client.newCall(request).execute();){
                int statusCode = response.code();
                log.info("invokeDouble url {} response statusCode:{}", (Object)finalUrl, (Object)statusCode);
                if (statusCode != 200) {
                    log.error("invokeDouble error message:{}, body: {}", (Object)response.message(), (Object)response.body().string());
                }
            }
            catch (Exception e) {
                log.error("invokeDouble error ", (Throwable)e);
            }
        });
    }

    public String matchRoutePath() {
        if (this.config == null || !Boolean.TRUE.equals(this.config.getFeign().getEnabled()) || CollectionUtils.isEmpty(this.config.getFeign().getRouteConfigList())) {
            return null;
        }
        FeignConfig.RouteConfig routeConfig = this.config.getFeign().getRouteConfigList().get(this.sourceRoutePath);
        if (routeConfig == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)routeConfig.getSourceRoutePath())) {
            return null;
        }
        TenantInfoHolder.TenantInfo tenantInfo = TenantInfoHolder.getTenantInfo();
        if (tenantInfo == null || StringUtils.isEmpty((CharSequence)tenantInfo.getTenantCode()) && tenantInfo.getTenantId() == null) {
            return null;
        }
        String targetRoutePath = null;
        if (!CollectionUtils.isEmpty(routeConfig.getTenantIdList()) && routeConfig.getTenantIdList().contains(tenantInfo.getTenantId()) || !CollectionUtils.isEmpty(routeConfig.getTenantCodeList()) && routeConfig.getTenantCodeList().contains(tenantInfo.getTenantCode())) {
            targetRoutePath = routeConfig.getTargetRoutePath();
            log.info("matchRoutePath tenantId:{}, tenantCode:{}, sourceRoutePath:{}, targetRoutePath:{}", new Object[]{tenantInfo.getTenantId(), tenantInfo.getTenantCode(), routeConfig.getSourceRoutePath(), targetRoutePath});
        }
        return targetRoutePath;
    }
}

