package com.xforceplus.purconfig.client.api;

import com.xforceplus.purconfig.client.model.MsBlockTabResponse;
import com.xforceplus.purconfig.client.model.MsCreateAuthBlockRequest;
import com.xforceplus.purconfig.client.model.MsDeleteAuthBlockRequest;
import com.xforceplus.purconfig.client.model.MsFindAuthBlockRequest;
import com.xforceplus.purconfig.client.model.MsFindAuthBlockResponse;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsListAuthBlockRequest;
import com.xforceplus.purconfig.client.model.MsListAuthBlockResponse;
import com.xforceplus.purconfig.client.model.MsUpdateAuthBlockRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "auth-block", description = "the auth-block API")
public interface AuthBlockApi {

    @ApiOperation(value = "tab分页", notes = "", response = MsBlockTabResponse.class, tags={ "AuthBlock", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsBlockTabResponse.class) })
    @RequestMapping(value = "/auth-block/blockTab",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsBlockTabResponse blockTab(@ApiParam(value = "request" ,required=true ) @RequestBody MsListAuthBlockRequest request);


    @ApiOperation(value = "新增认证封锁", notes = "", response = MsGeneralResponse.class, tags={ "AuthBlock", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/auth-block/createAuthBlock",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse createAuthBlock(@ApiParam(value = "request" ,required=true ) @RequestBody MsCreateAuthBlockRequest request);


    @ApiOperation(value = "删除认证封锁", notes = "", response = MsGeneralResponse.class, tags={ "AuthBlock", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/auth-block/deleteAuthBlock",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse deleteAuthBlock(@ApiParam(value = "request" ,required=true ) @RequestBody MsDeleteAuthBlockRequest request);


    @ApiOperation(value = "外部查询认证封锁", notes = "", response = MsFindAuthBlockResponse.class, tags={ "AuthBlock", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsFindAuthBlockResponse.class) })
    @RequestMapping(value = "/auth-block/findAuthBlock",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsFindAuthBlockResponse findAuthBlock(@ApiParam(value = "request" ,required=true ) @RequestBody MsFindAuthBlockRequest request);


    @ApiOperation(value = "查询认证封锁列表", notes = "", response = MsListAuthBlockResponse.class, tags={ "AuthBlock", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsListAuthBlockResponse.class) })
    @RequestMapping(value = "/auth-block/listAuthBlock",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsListAuthBlockResponse listAuthBlock(@ApiParam(value = "request" ,required=true ) @RequestBody MsListAuthBlockRequest request);


    @ApiOperation(value = "更新认证封锁", notes = "", response = MsGeneralResponse.class, tags={ "AuthBlock", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/auth-block/updateAuthBlock",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse updateAuthBlock(@ApiParam(value = "request" ,required=true ) @RequestBody MsUpdateAuthBlockRequest request);

}
