package com.xforceplus.purconfig.client.api;

import com.xforceplus.purconfig.client.model.MsCreateAuthQuotaRequest;
import com.xforceplus.purconfig.client.model.MsDeleteAuthQuotaRequest;
import com.xforceplus.purconfig.client.model.MsFindAuthQuotaRequest;
import com.xforceplus.purconfig.client.model.MsFindAuthQuotaResponse;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsListAuthQuotaRequest;
import com.xforceplus.purconfig.client.model.MsListAuthQuotaResponse;
import com.xforceplus.purconfig.client.model.MsQuotaTabResponse;
import com.xforceplus.purconfig.client.model.MsUpdateAuthQuotaRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "auth-quota", description = "the auth-quota API")
public interface AuthQuotaApi {

    @ApiOperation(value = "新增认证限额", notes = "", response = MsGeneralResponse.class, tags={ "AuthQuota", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/auth-quota/createAuthQuota",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse createAuthQuota(@ApiParam(value = "request" ,required=true ) @RequestBody MsCreateAuthQuotaRequest request);


    @ApiOperation(value = "删除认证限额", notes = "", response = MsGeneralResponse.class, tags={ "AuthQuota", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/auth-quota/deleteAuthQuota",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse deleteAuthQuota(@ApiParam(value = "request" ,required=true ) @RequestBody MsDeleteAuthQuotaRequest request);


    @ApiOperation(value = "查询公司认证限额", notes = "", response = MsFindAuthQuotaResponse.class, tags={ "AuthQuota", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsFindAuthQuotaResponse.class) })
    @RequestMapping(value = "/auth-quota/findAuthQuota",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsFindAuthQuotaResponse findAuthQuota(@ApiParam(value = "request" ,required=true ) @RequestBody MsFindAuthQuotaRequest request);


    @ApiOperation(value = "查询认证限额列表", notes = "", response = MsListAuthQuotaResponse.class, tags={ "AuthQuota", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsListAuthQuotaResponse.class) })
    @RequestMapping(value = "/auth-quota/listAuthQuota",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsListAuthQuotaResponse listAuthQuota(@ApiParam(value = "request" ,required=true ) @RequestBody MsListAuthQuotaRequest request);


    @ApiOperation(value = "tab分页", notes = "", response = MsQuotaTabResponse.class, tags={ "AuthQuota", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsQuotaTabResponse.class) })
    @RequestMapping(value = "/auth-quota/quotaTab",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsQuotaTabResponse quotaTab(@ApiParam(value = "request" ,required=true ) @RequestBody MsListAuthQuotaRequest request);


    @ApiOperation(value = "更新认证限额", notes = "", response = MsGeneralResponse.class, tags={ "AuthQuota", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/auth-quota/updateAuthQuota",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse updateAuthQuota(@ApiParam(value = "request" ,required=true ) @RequestBody MsUpdateAuthQuotaRequest request);

}
