package com.xforceplus.purconfig.client.api;

import com.xforceplus.purconfig.client.model.MsConfigGroupRequest;
import com.xforceplus.purconfig.client.model.MsConfigItemFieldEnumResponse;
import com.xforceplus.purconfig.client.model.MsConfigItemFieldModifyResponse;
import com.xforceplus.purconfig.client.model.MsDeleteConfigGroupRequest;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsGetConfigGroupByParamsRequest;
import com.xforceplus.purconfig.client.model.MsGetConfigGroupRequest;
import com.xforceplus.purconfig.client.model.MsGetConfigGroupResponse;
import com.xforceplus.purconfig.client.model.MsGetOrgInfoTreeRequest;
import com.xforceplus.purconfig.client.model.MsGetOrgInfoTreeResponse;
import com.xforceplus.purconfig.client.model.MsGetTurnOutConfigResponse;
import com.xforceplus.purconfig.client.model.MsListConfigGroupRequest;
import com.xforceplus.purconfig.client.model.MsListConfigGroupResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "config-group", description = "the config-group API")
public interface ConfigGroupApi {

    @ApiOperation(value = "创建配置组", notes = "", response = MsGeneralResponse.class, tags={ "ConfigGroup", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/config-group/craeteConfigGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse craeteConfigGroup(@ApiParam(value = "request" ,required=true ) @RequestBody MsConfigGroupRequest request);


    @ApiOperation(value = "删除配置组", notes = "", response = MsGeneralResponse.class, tags={ "ConfigGroup", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/config-group/deleteConfigGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse deleteConfigGroup(@ApiParam(value = "request" ,required=true ) @RequestBody MsDeleteConfigGroupRequest request);


    @ApiOperation(value = "获取配置组", notes = "", response = MsGetConfigGroupResponse.class, tags={ "ConfigGroup", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGetConfigGroupResponse.class) })
    @RequestMapping(value = "/config-group/getConfigGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetConfigGroupResponse getConfigGroup(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetConfigGroupRequest request);


    @ApiOperation(value = "根据参数条件获取配置组", notes = "", response = MsGetConfigGroupResponse.class, tags={ "ConfigGroup", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGetConfigGroupResponse.class) })
    @RequestMapping(value = "/config-group/getConfigGroupByParams",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetConfigGroupResponse getConfigGroupByParams(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetConfigGroupByParamsRequest request);


    @ApiOperation(value = "根据参数条件获取字段枚举值", notes = "", response = MsConfigItemFieldEnumResponse.class, tags={ "ConfigGroup", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsConfigItemFieldEnumResponse.class) })
    @RequestMapping(value = "/config-group/getConfigItemByParams/fieldEnum",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsConfigItemFieldEnumResponse getConfigItemFieldEnum( @NotNull @ApiParam(value = "枚举值字段名", required = true) @RequestParam(value = "fieldName", required = true) String fieldName, @NotNull @ApiParam(value = "集团ID", required = true) @RequestParam(value = "groupId", required = true) Long groupId);


    @ApiOperation(value = "根据参数条件获取字段可以修改的配置项", notes = "", response = MsConfigItemFieldModifyResponse.class, tags={ "ConfigGroup", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsConfigItemFieldModifyResponse.class) })
    @RequestMapping(value = "/config-group/getConfigItemByParams/fieldModify",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsConfigItemFieldModifyResponse getConfigItemFieldModify( @NotNull @ApiParam(value = "枚举值字段名", required = true) @RequestParam(value = "fieldName", required = true) String fieldName, @NotNull @ApiParam(value = "集团ID", required = true) @RequestParam(value = "groupId", required = true) Long groupId, @ApiParam(value = "枚举值字段值") @RequestParam(value = "fieldValue", required = false) String fieldValue);


    @ApiOperation(value = "获取组织树", notes = "", response = MsGetOrgInfoTreeResponse.class, tags={ "ConfigGroup", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGetOrgInfoTreeResponse.class) })
    @RequestMapping(value = "/config-group/getOrgInfoTree",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetOrgInfoTreeResponse getOrgInfoTree(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetOrgInfoTreeRequest request);


    @ApiOperation(value = "获取进转出配置", notes = "", response = MsGetTurnOutConfigResponse.class, tags={  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGetTurnOutConfigResponse.class) })
    @RequestMapping(value = "/config-group/getTurnOutConfig",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetTurnOutConfigResponse getTurnOutConfig(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetConfigGroupRequest request);


    @ApiOperation(value = "配置组列表", notes = "", response = MsListConfigGroupResponse.class, tags={ "ConfigGroup", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsListConfigGroupResponse.class) })
    @RequestMapping(value = "/config-group/listConfigGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsListConfigGroupResponse listConfigGroup(@ApiParam(value = "request" ,required=true ) @RequestBody MsListConfigGroupRequest request);


    @ApiOperation(value = "修改配置组", notes = "", response = MsGeneralResponse.class, tags={ "ConfigGroup", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/config-group/updateConfigGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse updateConfigGroup(@ApiParam(value = "request" ,required=true ) @RequestBody MsConfigGroupRequest request);

}
