package com.xforceplus.purconfig.client.api;

import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.config.*;
import com.xforceplus.purconfig.client.model.config.item.ConfigItemListResponse;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "configGroupItem", description = "the configGroupItem API")
public interface ConfigItemApi {

    @ApiOperation(value = "获取配置项", notes = "", response = MsGeneralResponse.class, tags = {"config-item",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "获取配置项结果", response = ConfigItemResponse.class)})
    @RequestMapping(value = "/config-item/getConfigItem",
            produces = {"application/json"},
            method = RequestMethod.POST)
    ConfigItemResponse getConfigItem(@ApiParam(value = "获取配置项请求", required = true) @RequestBody ConfigItemRequest request);

    @ApiOperation(value = "获取配置项集合", notes = "", response = MsGeneralResponse.class, tags = {"config-item",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "获取配置项结果", response = ConfigItemResponse.class)})
    @RequestMapping(value = "/config-item/getConfigItemList",
            produces = {"application/json"},
            method = RequestMethod.POST)
    ConfigItemListResponse getConfigItemList(@ApiParam(value = "获取配置项请求", required = true) @RequestBody ConfigItemRequest request);


    @ApiOperation(value = "配置项列表查询", notes = "", response = MsGeneralResponse.class, tags = {"config-item",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "获取配置项结果", response = ConfigItemResponse.class)})
    @RequestMapping(value = "/config-item/listConfigItem",
            produces = {"application/json"},
            method = RequestMethod.POST)
    ListConfigItemResponse listConfigItem(@ApiParam(value = "获取配置项请求", required = true) @RequestBody ListConfigItemRequest request);

    @ApiOperation(value = "获取全部预警天数配置", notes = "", response = MsGeneralResponse.class, tags = {"config-item",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "获取预警天数结果", response = ListAuthWarnDayResponse.class)})
    @RequestMapping(value = "/config-item/getAllAuthWarnDayConfig",
            produces = {"application/json"},
            method = RequestMethod.POST)
    ListAuthWarnDayResponse getAllAuthWarnDayConfig();


}
