package com.xforceplus.purconfig.client.api;

import com.xforceplus.purconfig.client.model.MsGetCustomColumnRequest;
import com.xforceplus.purconfig.client.model.MsGetCustomColumnResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "customColumn", description = "the customColumn API")
public interface CustomColumnApi {

    @ApiOperation(value = "获取自定义列配置", notes = "", response = MsGetCustomColumnResponse.class, tags={ "CustomColumn", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGetCustomColumnResponse.class) })
    @RequestMapping(value = "/customColumn/getCustomColumn",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetCustomColumnResponse getCustomColumn(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetCustomColumnRequest request);

}
