package com.xforceplus.purconfig.client.api;

import com.xforceplus.purconfig.client.model.MsCommonCodeQueryRequest;
import com.xforceplus.purconfig.client.model.MsCommonCodeResponse;
import com.xforceplus.purconfig.client.model.MsFieldConfigCommonQueryRequest;
import com.xforceplus.purconfig.client.model.MsFieldConfigCommonResponse;
import com.xforceplus.purconfig.client.model.MsFieldConfigGroupQueryRequest;
import com.xforceplus.purconfig.client.model.MsFieldConfigGroupRequest;
import com.xforceplus.purconfig.client.model.MsFieldConfigGroupResponse;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "field-config", description = "the field-config API")
public interface FieldConfigApi {

    @ApiOperation(value = "添加租户维度字段配置", notes = "", response = MsGeneralResponse.class, tags={ "Field-Config", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/field-config/group/addFieldConfigGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse addFieldConfigGroup(@ApiParam(value = "request" ,required=true ) @RequestBody MsFieldConfigGroupRequest request);


    @ApiOperation(value = "根据条件获取公用-代码表", notes = "", response = MsCommonCodeResponse.class, tags={ "Field-Config", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsCommonCodeResponse.class) })
    @RequestMapping(value = "/field-config/common-code/getCommonCode",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsCommonCodeResponse getCommonCode(@ApiParam(value = "request" ,required=true ) @RequestBody MsCommonCodeQueryRequest request);


    @ApiOperation(value = "查询系统通用字段配置表", notes = "", response = MsFieldConfigCommonResponse.class, tags={ "Field-Config", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsFieldConfigCommonResponse.class) })
    @RequestMapping(value = "/field-config/common/getFieldConfigCommon",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsFieldConfigCommonResponse getFieldConfigCommon(@ApiParam(value = "request" ,required=true ) @RequestBody MsFieldConfigCommonQueryRequest request);


    @ApiOperation(value = "查询租户维度字段配置", notes = "", response = MsFieldConfigGroupResponse.class, tags={ "Field-Config", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsFieldConfigGroupResponse.class) })
    @RequestMapping(value = "/field-config/group/getFieldConfigGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsFieldConfigGroupResponse getFieldConfigGroup(@ApiParam(value = "request" ,required=true ) @RequestBody MsFieldConfigGroupQueryRequest request);


    @ApiOperation(value = "根据租户id获取字段列表", notes = "", response = MsFieldConfigGroupResponse.class, tags={ "Field-Config", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsFieldConfigGroupResponse.class) })
    @RequestMapping(value = "/field-config/group/getFieldsByTenantId/{tenantId}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsFieldConfigGroupResponse getFieldsByTenantId(@ApiParam(value = "tenantId",required=true ) @PathVariable("tenantId") Long tenantId);


    @ApiOperation(value = "更新租户维度字段配置", notes = "", response = MsGeneralResponse.class, tags={ "Field-Config", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/field-config/group/updateFieldConfigGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse updateFieldConfigGroup(@ApiParam(value = "request" ,required=true ) @RequestBody MsFieldConfigGroupRequest request);

}
