package com.xforceplus.purconfig.client.api;

import java.util.List;
import com.xforceplus.purconfig.client.model.MsFilterConditionInfoRequest;
import com.xforceplus.purconfig.client.model.MsFilterGroupInfoRequest;
import com.xforceplus.purconfig.client.model.MsFilterGroupRequest;
import com.xforceplus.purconfig.client.model.MsFilterGroupResponse;
import com.xforceplus.purconfig.client.model.MsFilterTemplateResponse;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsImportInvoiceRequest;
import com.xforceplus.purconfig.client.model.MsInvoiceFilterResponse;
import com.xforceplus.purconfig.client.model.MsInvoiceInfoResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "filter", description = "the filter API")
public interface FilterApi {

    @ApiOperation(value = "删除筛选器组", notes = "", response = MsGeneralResponse.class, tags={ "Filter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/filter/deleteFilterGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse deleteFilterGroup(@ApiParam(value = "组id" ,required=true ) @RequestBody Long groupId);


    @ApiOperation(value = "下载导入筛选器发票模板", notes = "", response = MsFilterTemplateResponse.class, tags={ "Filter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsFilterTemplateResponse.class) })
    @RequestMapping(value = "/filter/downloadFilterTemplate",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsFilterTemplateResponse downloadFilterTemplate();


    @ApiOperation(value = "已选筛选器组", notes = "", response = MsFilterGroupResponse.class, tags={ "Filter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsFilterGroupResponse.class) })
    @RequestMapping(value = "/filter/getCheckedFilterGroups",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsFilterGroupResponse getCheckedFilterGroups(@ApiParam(value = "request" ,required=true ) @RequestBody MsFilterGroupRequest request);


    @ApiOperation(value = "筛选器集合", notes = "", response = MsInvoiceFilterResponse.class, tags={ "Filter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsInvoiceFilterResponse.class) })
    @RequestMapping(value = "/filter/getFilterDatas",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsInvoiceFilterResponse getFilterDatas( @NotNull @ApiParam(value = "页面类型：1-发票管理；2-发票认证", required = true) @RequestParam(value = "resourceType", required = true) Integer resourceType, @NotNull @ApiParam(value = "", required = true) @RequestParam(value = "groupId", required = true) Long groupId);


    @ApiOperation(value = "导入发票号码，代码", notes = "", response = MsInvoiceInfoResponse.class, tags={ "Filter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsInvoiceInfoResponse.class) })
    @RequestMapping(value = "/filter/importInvoiceData",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsInvoiceInfoResponse importInvoiceData(@ApiParam(value = "request" ,required=true ) @RequestBody MsImportInvoiceRequest request);


    @ApiOperation(value = "添加筛选器组", notes = "", response = MsGeneralResponse.class, tags={ "Filter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/filter/insertFilterGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse insertFilterGroup(@ApiParam(value = "request" ,required=true ) @RequestBody MsFilterGroupRequest request);


    @ApiOperation(value = "编辑筛选条件", notes = "", response = MsGeneralResponse.class, tags={ "Filter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/filter/updateFilterCondition",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse updateFilterCondition(@ApiParam(value = "request" ,required=true ) @RequestBody MsFilterConditionInfoRequest request);


    @ApiOperation(value = "编辑筛选器组", notes = "", response = MsGeneralResponse.class, tags={ "Filter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/filter/updateFilterGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse updateFilterGroup(@ApiParam(value = "request" ,required=true ) @RequestBody List<MsFilterGroupInfoRequest> request);

}
