package com.xforceplus.purconfig.client.api;

import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsOptionsRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "function-point", description = "the function-point API")
public interface FunctionPointApi {

    @ApiOperation(value = "获取租户扩展点配置", notes = "", response = MsGeneralResponse.class, tags={ "Function-Point", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/function-point/options",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse options(@ApiParam(value = "request" ,required=true ) @RequestBody MsOptionsRequest request);

}
