package com.xforceplus.purconfig.client.api;

import com.xforceplus.purconfig.client.model.MsDeleteGoodsRequest;
import com.xforceplus.purconfig.client.model.MsExcelImportResponse;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsGetGoodsInfoRequest;
import com.xforceplus.purconfig.client.model.MsGoodsInfoRequest;
import com.xforceplus.purconfig.client.model.MsGoodsTemplateResponse;
import com.xforceplus.purconfig.client.model.MsImportGoodsDataRequest;
import com.xforceplus.purconfig.client.model.MsListGoodsInfoRequest;
import com.xforceplus.purconfig.client.model.MsListGoodsInfoResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "goods", description = "the goods API")
public interface GoodsApi {

    @ApiOperation(value = "创建商品信息", notes = "", response = MsGeneralResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/goods/createGoodsInfo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse createGoodsInfo(@ApiParam(value = "request" ,required=true ) @RequestBody MsGoodsInfoRequest request);


    @ApiOperation(value = "删除商品信息", notes = "", response = MsGeneralResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/goods/deleteGoodsInfo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse deleteGoodsInfo(@ApiParam(value = "request" ,required=true ) @RequestBody MsDeleteGoodsRequest request);


    @ApiOperation(value = "下载采购商品导入模板", notes = "", response = MsGoodsTemplateResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsGoodsTemplateResponse.class) })
    @RequestMapping(value = "/goods/downloadGoodsTemplate",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGoodsTemplateResponse downloadGoodsTemplate();


    @ApiOperation(value = "获取商品信息", notes = "", response = MsListGoodsInfoResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsListGoodsInfoResponse.class) })
    @RequestMapping(value = "/goods/getGoodsInfo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsListGoodsInfoResponse getGoodsInfo(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetGoodsInfoRequest request);


    @ApiOperation(value = "导入数据", notes = "", response = MsExcelImportResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsExcelImportResponse.class) })
    @RequestMapping(value = "/goods/importGoodsData",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsExcelImportResponse importGoodsData(@ApiParam(value = "request" ,required=true ) @RequestBody MsImportGoodsDataRequest request);


    @ApiOperation(value = "商品信息列表", notes = "", response = MsListGoodsInfoResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsListGoodsInfoResponse.class) })
    @RequestMapping(value = "/goods/listGoodsInfo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsListGoodsInfoResponse listGoodsInfo(@ApiParam(value = "request" ,required=true ) @RequestBody MsListGoodsInfoRequest request);


    @ApiOperation(value = "修改商品信息", notes = "", response = MsGeneralResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/goods/updateGoodsInfo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse updateGoodsInfo(@ApiParam(value = "request" ,required=true ) @RequestBody MsGoodsInfoRequest request);

}
