package com.xforceplus.purconfig.client.api;

import com.xforceplus.purconfig.client.model.MsDeleteSimpleCollectionRequest;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsGoodsTemplateResponse;
import com.xforceplus.purconfig.client.model.MsImportExcelRequest;
import com.xforceplus.purconfig.client.model.MsInsertSimpleCollectionRequest;
import com.xforceplus.purconfig.client.model.MsListSimpleCollectionRequest;
import com.xforceplus.purconfig.client.model.MsListSimpleCollectionResponse;
import com.xforceplus.purconfig.client.model.MsUpdateSimpleCollectionRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "simple-collection", description = "the simple-collection API")
public interface SimpleCollectionApi {

    @ApiOperation(value = "删除简易征税配置", notes = "", response = MsGeneralResponse.class, tags={ "SimpleCollection", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/simple-collection/record/delete/batch",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
     MsGeneralResponse deleteSimpleCollection(@ApiParam(value = "request" ,required=true ) @RequestBody MsDeleteSimpleCollectionRequest request);


    @ApiOperation(value = "获取导入模板", notes = "", response = MsGoodsTemplateResponse.class, tags={ "SimpleCollection", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsGoodsTemplateResponse.class) })
    @RequestMapping(value = "/simple-collection/import/template",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsGoodsTemplateResponse downloadSimpleCollectionTemplate();


    @ApiOperation(value = "导入简易征税配置excel", notes = "", response = MsGeneralResponse.class, tags={ "SimpleCollection", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/simple-collection/import",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse importExcel(@ApiParam(value = "request" ,required=true ) @RequestBody MsImportExcelRequest request);


    @ApiOperation(value = "新增简易征税配置", notes = "", response = MsGeneralResponse.class, tags={ "SimpleCollection", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/simple-collection/record",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGeneralResponse insertSimpleCollection(@ApiParam(value = "request" ,required=true ) @RequestBody MsInsertSimpleCollectionRequest request);


    @ApiOperation(value = "查询简易征税列表", notes = "", response = MsListSimpleCollectionResponse.class, tags={ "SimpleCollection", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsListSimpleCollectionResponse.class) })
    @RequestMapping(value = "/simple-collection/list/{pageStatus}",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsListSimpleCollectionResponse listSimpleCollection(@ApiParam(value = "pageStatus",required=true ) @PathVariable("pageStatus") Integer pageStatus,@ApiParam(value = "request" ,required=true ) @RequestBody MsListSimpleCollectionRequest request);


    @ApiOperation(value = "更新简易征税配置", notes = "", response = MsGeneralResponse.class, tags={ "SimpleCollection", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsGeneralResponse.class) })
    @RequestMapping(value = "/simple-collection/record/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     MsGeneralResponse updateSimpleCollection(@ApiParam(value = "规则id",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody MsUpdateSimpleCollectionRequest request);

}
