package com.xforceplus.purconfig.client.api;

import com.xforceplus.purconfig.client.model.MsOrgListRequest;
import com.xforceplus.purconfig.client.model.MsOrgListResponse;
import com.xforceplus.purconfig.client.model.MsUcenterCompanyListResponse;
import com.xforceplus.purconfig.client.model.MsUcenterCompanyRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "ucenter", description = "the ucenter API")
public interface UcenterApi {

    @ApiOperation(value = "根据条件获取公司信息", notes = "", response = MsUcenterCompanyListResponse.class, tags={ "UCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsUcenterCompanyListResponse.class) })
    @RequestMapping(value = "/ucenter/companys",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsUcenterCompanyListResponse getAllCompanyListByCondition(@ApiParam(value = "request" ,required=true ) @RequestBody MsUcenterCompanyRequest request);


    @ApiOperation(value = "根据条件获取用户组织信息", notes = "", response = MsOrgListResponse.class, tags={ "UCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应结果", response = MsOrgListResponse.class) })
    @RequestMapping(value = "/ucenter/orgs",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOrgListResponse getAllOrgListByCondition(@ApiParam(value = "request" ,required=true ) @RequestBody MsOrgListRequest request);

}
