package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsListAuthQuota;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 限额信息列表
 */
@ApiModel(description = "限额信息列表")

@JsonInclude(NON_NULL)
public class MsAuthQuotaResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsListAuthQuota> result = new ArrayList<MsListAuthQuota>();

  @JsonIgnore
  public MsAuthQuotaResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * Get code
   * @return code
  **/
  @ApiModelProperty(value = "")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsAuthQuotaResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsAuthQuotaResponse result(List<MsListAuthQuota> result) {
    this.result = result;
    return this;
  }

  public MsAuthQuotaResponse addResultItem(MsListAuthQuota resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 限额信息
   * @return result
  **/
  @ApiModelProperty(value = "限额信息")
  public List<MsListAuthQuota> getResult() {
    return result;
  }

  public void setResult(List<MsListAuthQuota> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAuthQuotaResponse authQuotaResponse = (MsAuthQuotaResponse) o;
    return Objects.equals(this.code, authQuotaResponse.code) &&
        Objects.equals(this.message, authQuotaResponse.message) &&
        Objects.equals(this.result, authQuotaResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAuthQuotaResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
