package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 封锁tab统计
 */
@ApiModel(description = "封锁tab统计")

@JsonInclude(NON_NULL)
public class MsBlockTotalDetail {
  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("totalCount")
  private Integer totalCount = null;

  @JsonProperty("name")
  private String name = null;

  @JsonIgnore
  public MsBlockTotalDetail status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 1-未封锁，2-已封锁
   * @return status
  **/
  @ApiModelProperty(value = "1-未封锁，2-已封锁")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsBlockTotalDetail totalCount(Integer totalCount) {
    this.totalCount = totalCount;
    return this;
  }

   /**
   * 当前状态数据
   * @return totalCount
  **/
  @ApiModelProperty(value = "当前状态数据")
  public Integer getTotalCount() {
    return totalCount;
  }

  public void setTotalCount(Integer totalCount) {
    this.totalCount = totalCount;
  }

  @JsonIgnore
  public MsBlockTotalDetail name(String name) {
    this.name = name;
    return this;
  }

   /**
   * tab页名称
   * @return name
  **/
  @ApiModelProperty(value = "tab页名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBlockTotalDetail blockTotalDetail = (MsBlockTotalDetail) o;
    return Objects.equals(this.status, blockTotalDetail.status) &&
        Objects.equals(this.totalCount, blockTotalDetail.totalCount) &&
        Objects.equals(this.name, blockTotalDetail.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, totalCount, name);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBlockTotalDetail {\n");
    
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    totalCount: ").append(toIndentedString(totalCount)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
