package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 公用-代码表
 */
@ApiModel(description = "公用-代码表")

@JsonInclude(NON_NULL)
public class MsCommonCode {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("code")
  private String code = null;

  @JsonProperty("codeValue")
  private String codeValue = null;

  @JsonProperty("codeExtValue")
  private String codeExtValue = null;

  @JsonProperty("seq")
  private Integer seq = null;

  @JsonProperty("groupCode")
  private String groupCode = null;

  @JsonProperty("groupDesc")
  private String groupDesc = null;

  @JsonProperty("isSysCode")
  private Integer isSysCode = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonProperty("operateType")
  private String operateType = null;

  @JsonIgnore
  public MsCommonCode id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsCommonCode code(String code) {
    this.code = code;
    return this;
  }

   /**
   * 字典值
   * @return code
  **/
  @ApiModelProperty(value = "字典值")
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  @JsonIgnore
  public MsCommonCode codeValue(String codeValue) {
    this.codeValue = codeValue;
    return this;
  }

   /**
   * 字典名称
   * @return codeValue
  **/
  @ApiModelProperty(value = "字典名称")
  public String getCodeValue() {
    return codeValue;
  }

  public void setCodeValue(String codeValue) {
    this.codeValue = codeValue;
  }

  @JsonIgnore
  public MsCommonCode codeExtValue(String codeExtValue) {
    this.codeExtValue = codeExtValue;
    return this;
  }

   /**
   * 扩展值
   * @return codeExtValue
  **/
  @ApiModelProperty(value = "扩展值")
  public String getCodeExtValue() {
    return codeExtValue;
  }

  public void setCodeExtValue(String codeExtValue) {
    this.codeExtValue = codeExtValue;
  }

  @JsonIgnore
  public MsCommonCode seq(Integer seq) {
    this.seq = seq;
    return this;
  }

   /**
   * 排序
   * @return seq
  **/
  @ApiModelProperty(value = "排序")
  public Integer getSeq() {
    return seq;
  }

  public void setSeq(Integer seq) {
    this.seq = seq;
  }

  @JsonIgnore
  public MsCommonCode groupCode(String groupCode) {
    this.groupCode = groupCode;
    return this;
  }

   /**
   * 字典表分组(comm_code.group_code)
   * @return groupCode
  **/
  @ApiModelProperty(value = "字典表分组(comm_code.group_code)")
  public String getGroupCode() {
    return groupCode;
  }

  public void setGroupCode(String groupCode) {
    this.groupCode = groupCode;
  }

  @JsonIgnore
  public MsCommonCode groupDesc(String groupDesc) {
    this.groupDesc = groupDesc;
    return this;
  }

   /**
   * 分组描述
   * @return groupDesc
  **/
  @ApiModelProperty(value = "分组描述")
  public String getGroupDesc() {
    return groupDesc;
  }

  public void setGroupDesc(String groupDesc) {
    this.groupDesc = groupDesc;
  }

  @JsonIgnore
  public MsCommonCode isSysCode(Integer isSysCode) {
    this.isSysCode = isSysCode;
    return this;
  }

   /**
   * 是否系统内置（1系统 0 租户定义）
   * @return isSysCode
  **/
  @ApiModelProperty(value = "是否系统内置（1系统 0 租户定义）")
  public Integer getIsSysCode() {
    return isSysCode;
  }

  public void setIsSysCode(Integer isSysCode) {
    this.isSysCode = isSysCode;
  }

  @JsonIgnore
  public MsCommonCode tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsCommonCode status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 是否启用(1-启用，0-禁用)
   * @return status
  **/
  @ApiModelProperty(value = "是否启用(1-启用，0-禁用)")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsCommonCode createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsCommonCode updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public MsCommonCode operateType(String operateType) {
    this.operateType = operateType;
    return this;
  }

   /**
   * 操作类型(1-修改，0-新增)
   * @return operateType
  **/
  @ApiModelProperty(value = "操作类型(1-修改，0-新增)")
  public String getOperateType() {
    return operateType;
  }

  public void setOperateType(String operateType) {
    this.operateType = operateType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCommonCode commonCode = (MsCommonCode) o;
    return Objects.equals(this.id, commonCode.id) &&
        Objects.equals(this.code, commonCode.code) &&
        Objects.equals(this.codeValue, commonCode.codeValue) &&
        Objects.equals(this.codeExtValue, commonCode.codeExtValue) &&
        Objects.equals(this.seq, commonCode.seq) &&
        Objects.equals(this.groupCode, commonCode.groupCode) &&
        Objects.equals(this.groupDesc, commonCode.groupDesc) &&
        Objects.equals(this.isSysCode, commonCode.isSysCode) &&
        Objects.equals(this.tenantId, commonCode.tenantId) &&
        Objects.equals(this.status, commonCode.status) &&
        Objects.equals(this.createTime, commonCode.createTime) &&
        Objects.equals(this.updateTime, commonCode.updateTime) &&
        Objects.equals(this.operateType, commonCode.operateType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, code, codeValue, codeExtValue, seq, groupCode, groupDesc, isSysCode, tenantId, status, createTime, updateTime, operateType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCommonCode {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    codeValue: ").append(toIndentedString(codeValue)).append("\n");
    sb.append("    codeExtValue: ").append(toIndentedString(codeExtValue)).append("\n");
    sb.append("    seq: ").append(toIndentedString(seq)).append("\n");
    sb.append("    groupCode: ").append(toIndentedString(groupCode)).append("\n");
    sb.append("    groupDesc: ").append(toIndentedString(groupDesc)).append("\n");
    sb.append("    isSysCode: ").append(toIndentedString(isSysCode)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    operateType: ").append(toIndentedString(operateType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
