package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取公用-代码表查询入参
 */
@ApiModel(description = "获取公用-代码表查询入参")

@JsonInclude(NON_NULL)
public class MsCommonCodeQueryRequest {
  @JsonProperty("groupCode")
  private String groupCode = null;

  @JsonProperty("isSysCode")
  private Integer isSysCode = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsCommonCodeQueryRequest groupCode(String groupCode) {
    this.groupCode = groupCode;
    return this;
  }

   /**
   * 分组的键 （如果租户自定义字段 租户id+_ext）
   * @return groupCode
  **/
  @ApiModelProperty(value = "分组的键 （如果租户自定义字段 租户id+_ext）")
  public String getGroupCode() {
    return groupCode;
  }

  public void setGroupCode(String groupCode) {
    this.groupCode = groupCode;
  }

  @JsonIgnore
  public MsCommonCodeQueryRequest isSysCode(Integer isSysCode) {
    this.isSysCode = isSysCode;
    return this;
  }

   /**
   * 是否系统内置（1系统 0 租户定义）
   * @return isSysCode
  **/
  @ApiModelProperty(value = "是否系统内置（1系统 0 租户定义）")
  public Integer getIsSysCode() {
    return isSysCode;
  }

  public void setIsSysCode(Integer isSysCode) {
    this.isSysCode = isSysCode;
  }

  @JsonIgnore
  public MsCommonCodeQueryRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * Get userInfo
   * @return userInfo
  **/
  @ApiModelProperty(value = "")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCommonCodeQueryRequest commonCodeQueryRequest = (MsCommonCodeQueryRequest) o;
    return Objects.equals(this.groupCode, commonCodeQueryRequest.groupCode) &&
        Objects.equals(this.isSysCode, commonCodeQueryRequest.isSysCode) &&
        Objects.equals(this.userInfo, commonCodeQueryRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupCode, isSysCode, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCommonCodeQueryRequest {\n");
    
    sb.append("    groupCode: ").append(toIndentedString(groupCode)).append("\n");
    sb.append("    isSysCode: ").append(toIndentedString(isSysCode)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
