package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsConfigItem;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 配置组请求
 */
@ApiModel(description = "配置组请求")

@JsonInclude(NON_NULL)
public class MsConfigGroupRequest {
  @JsonProperty("configGroupId")
  private Long configGroupId = null;

  @JsonProperty("configGroupCode")
  private String configGroupCode = null;

  @JsonProperty("configGroupName")
  private String configGroupName = null;

  @JsonProperty("configGroupComment")
  private String configGroupComment = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonProperty("configItems")
  private List<MsConfigItem> configItems = new ArrayList<MsConfigItem>();

  @JsonProperty("effectRanges")
  private List<String> effectRanges = new ArrayList<String>();

  @JsonIgnore
  public MsConfigGroupRequest configGroupId(Long configGroupId) {
    this.configGroupId = configGroupId;
    return this;
  }

   /**
   * 配置组ID（修改数据时需要）
   * @return configGroupId
  **/
  @ApiModelProperty(value = "配置组ID（修改数据时需要）")
  public Long getConfigGroupId() {
    return configGroupId;
  }

  public void setConfigGroupId(Long configGroupId) {
    this.configGroupId = configGroupId;
  }

  @JsonIgnore
  public MsConfigGroupRequest configGroupCode(String configGroupCode) {
    this.configGroupCode = configGroupCode;
    return this;
  }

   /**
   * 配置组代码(RECOG_CONFIG：识别配置组；AUTH_CONFIG：认证配置组；VERIFY_CONFIG：查验配置组；COMPLIANCE_CONFIG：合规配置组)
   * @return configGroupCode
  **/
  @ApiModelProperty(value = "配置组代码(RECOG_CONFIG：识别配置组；AUTH_CONFIG：认证配置组；VERIFY_CONFIG：查验配置组；COMPLIANCE_CONFIG：合规配置组)")
  public String getConfigGroupCode() {
    return configGroupCode;
  }

  public void setConfigGroupCode(String configGroupCode) {
    this.configGroupCode = configGroupCode;
  }

  @JsonIgnore
  public MsConfigGroupRequest configGroupName(String configGroupName) {
    this.configGroupName = configGroupName;
    return this;
  }

   /**
   * 配置组名称
   * @return configGroupName
  **/
  @ApiModelProperty(value = "配置组名称")
  public String getConfigGroupName() {
    return configGroupName;
  }

  public void setConfigGroupName(String configGroupName) {
    this.configGroupName = configGroupName;
  }

  @JsonIgnore
  public MsConfigGroupRequest configGroupComment(String configGroupComment) {
    this.configGroupComment = configGroupComment;
    return this;
  }

   /**
   * 配置组备注
   * @return configGroupComment
  **/
  @ApiModelProperty(value = "配置组备注")
  public String getConfigGroupComment() {
    return configGroupComment;
  }

  public void setConfigGroupComment(String configGroupComment) {
    this.configGroupComment = configGroupComment;
  }

  @JsonIgnore
  public MsConfigGroupRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }

  @JsonIgnore
  public MsConfigGroupRequest configItems(List<MsConfigItem> configItems) {
    this.configItems = configItems;
    return this;
  }

  public MsConfigGroupRequest addConfigItemsItem(MsConfigItem configItemsItem) {
    this.configItems.add(configItemsItem);
    return this;
  }

   /**
   * 配置项数组
   * @return configItems
  **/
  @ApiModelProperty(value = "配置项数组")
  public List<MsConfigItem> getConfigItems() {
    return configItems;
  }

  public void setConfigItems(List<MsConfigItem> configItems) {
    this.configItems = configItems;
  }

  @JsonIgnore
  public MsConfigGroupRequest effectRanges(List<String> effectRanges) {
    this.effectRanges = effectRanges;
    return this;
  }

  public MsConfigGroupRequest addEffectRangesItem(String effectRangesItem) {
    this.effectRanges.add(effectRangesItem);
    return this;
  }

   /**
   * 生效范围数组(传入 orgStructId)
   * @return effectRanges
  **/
  @ApiModelProperty(value = "生效范围数组(传入 orgStructId)")
  public List<String> getEffectRanges() {
    return effectRanges;
  }

  public void setEffectRanges(List<String> effectRanges) {
    this.effectRanges = effectRanges;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigGroupRequest configGroupRequest = (MsConfigGroupRequest) o;
    return Objects.equals(this.configGroupId, configGroupRequest.configGroupId) &&
        Objects.equals(this.configGroupCode, configGroupRequest.configGroupCode) &&
        Objects.equals(this.configGroupName, configGroupRequest.configGroupName) &&
        Objects.equals(this.configGroupComment, configGroupRequest.configGroupComment) &&
        Objects.equals(this.userInfo, configGroupRequest.userInfo) &&
        Objects.equals(this.configItems, configGroupRequest.configItems) &&
        Objects.equals(this.effectRanges, configGroupRequest.effectRanges);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configGroupId, configGroupCode, configGroupName, configGroupComment, userInfo, configItems, effectRanges);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigGroupRequest {\n");
    
    sb.append("    configGroupId: ").append(toIndentedString(configGroupId)).append("\n");
    sb.append("    configGroupCode: ").append(toIndentedString(configGroupCode)).append("\n");
    sb.append("    configGroupName: ").append(toIndentedString(configGroupName)).append("\n");
    sb.append("    configGroupComment: ").append(toIndentedString(configGroupComment)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("    configItems: ").append(toIndentedString(configItems)).append("\n");
    sb.append("    effectRanges: ").append(toIndentedString(effectRanges)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
