package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 配置项信息
 */
@ApiModel(description = "配置项信息")

@JsonInclude(NON_NULL)
public class MsConfigItem {
  @JsonProperty("configItemId")
  private Long configItemId = null;

  @JsonProperty("configItemCode")
  private String configItemCode = null;

  @JsonProperty("configContent")
  private String configContent = null;

  @JsonIgnore
  public MsConfigItem configItemId(Long configItemId) {
    this.configItemId = configItemId;
    return this;
  }

   /**
   * 配置项ID（修改数据时需要）
   * @return configItemId
  **/
  @ApiModelProperty(value = "配置项ID（修改数据时需要）")
  public Long getConfigItemId() {
    return configItemId;
  }

  public void setConfigItemId(Long configItemId) {
    this.configItemId = configItemId;
  }

  @JsonIgnore
  public MsConfigItem configItemCode(String configItemCode) {
    this.configItemCode = configItemCode;
    return this;
  }

   /**
   * 配置项代码
   * @return configItemCode
  **/
  @ApiModelProperty(value = "配置项代码")
  public String getConfigItemCode() {
    return configItemCode;
  }

  public void setConfigItemCode(String configItemCode) {
    this.configItemCode = configItemCode;
  }

  @JsonIgnore
  public MsConfigItem configContent(String configContent) {
    this.configContent = configContent;
    return this;
  }

   /**
   * 配置内容(合法JSON字符串)
   * @return configContent
  **/
  @ApiModelProperty(value = "配置内容(合法JSON字符串)")
  public String getConfigContent() {
    return configContent;
  }

  public void setConfigContent(String configContent) {
    this.configContent = configContent;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigItem configItem = (MsConfigItem) o;
    return Objects.equals(this.configItemId, configItem.configItemId) &&
        Objects.equals(this.configItemCode, configItem.configItemCode) &&
        Objects.equals(this.configContent, configItem.configContent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configItemId, configItemCode, configContent);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigItem {\n");
    
    sb.append("    configItemId: ").append(toIndentedString(configItemId)).append("\n");
    sb.append("    configItemCode: ").append(toIndentedString(configItemCode)).append("\n");
    sb.append("    configContent: ").append(toIndentedString(configContent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
