package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsConfigItemFieldEnumResponseResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取的字段枚举值列表
 */
@ApiModel(description = "获取的字段枚举值列表")

@JsonInclude(NON_NULL)
public class MsConfigItemFieldEnumResponse {
  @JsonProperty("code")
  private Integer code = 0;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsConfigItemFieldEnumResponseResult> result = new ArrayList<MsConfigItemFieldEnumResponseResult>();

  @JsonIgnore
  public MsConfigItemFieldEnumResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsConfigItemFieldEnumResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回结果
   * @return message
  **/
  @ApiModelProperty(value = "返回结果")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsConfigItemFieldEnumResponse result(List<MsConfigItemFieldEnumResponseResult> result) {
    this.result = result;
    return this;
  }

  public MsConfigItemFieldEnumResponse addResultItem(MsConfigItemFieldEnumResponseResult resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * Get result
   * @return result
  **/
  @ApiModelProperty(value = "")
  public List<MsConfigItemFieldEnumResponseResult> getResult() {
    return result;
  }

  public void setResult(List<MsConfigItemFieldEnumResponseResult> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigItemFieldEnumResponse configItemFieldEnumResponse = (MsConfigItemFieldEnumResponse) o;
    return Objects.equals(this.code, configItemFieldEnumResponse.code) &&
        Objects.equals(this.message, configItemFieldEnumResponse.message) &&
        Objects.equals(this.result, configItemFieldEnumResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigItemFieldEnumResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
