package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigItemFieldEnumResponseResult
 */

@JsonInclude(NON_NULL)
public class MsConfigItemFieldEnumResponseResult {
  @JsonProperty("value")
  private String value = null;

  @JsonProperty("text")
  private String text = null;

  @JsonIgnore
  public MsConfigItemFieldEnumResponseResult value(String value) {
    this.value = value;
    return this;
  }

   /**
   * 值
   * @return value
  **/
  @ApiModelProperty(value = "值")
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @JsonIgnore
  public MsConfigItemFieldEnumResponseResult text(String text) {
    this.text = text;
    return this;
  }

   /**
   * 文本
   * @return text
  **/
  @ApiModelProperty(value = "文本")
  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigItemFieldEnumResponseResult configItemFieldEnumResponseResult = (MsConfigItemFieldEnumResponseResult) o;
    return Objects.equals(this.value, configItemFieldEnumResponseResult.value) &&
        Objects.equals(this.text, configItemFieldEnumResponseResult.text);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, text);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigItemFieldEnumResponseResult {\n");
    
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
