package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigItemFieldModifyResponseResult
 */

@JsonInclude(NON_NULL)
public class MsConfigItemFieldModifyResponseResult {
  @JsonProperty("controlLevel")
  private Boolean controlLevel = null;

  @JsonProperty("paramKey")
  private String paramKey = null;

  @JsonProperty("paramCondition")
  private String paramCondition = null;

  @JsonProperty("paramValue")
  private String paramValue = null;

  @JsonIgnore
  public MsConfigItemFieldModifyResponseResult controlLevel(Boolean controlLevel) {
    this.controlLevel = controlLevel;
    return this;
  }

   /**
   * 强校验弱校验
   * @return controlLevel
  **/
  @ApiModelProperty(value = "强校验弱校验")
  public Boolean getControlLevel() {
    return controlLevel;
  }

  public void setControlLevel(Boolean controlLevel) {
    this.controlLevel = controlLevel;
  }

  @JsonIgnore
  public MsConfigItemFieldModifyResponseResult paramKey(String paramKey) {
    this.paramKey = paramKey;
    return this;
  }

   /**
   * 权限条件字段
   * @return paramKey
  **/
  @ApiModelProperty(value = "权限条件字段")
  public String getParamKey() {
    return paramKey;
  }

  public void setParamKey(String paramKey) {
    this.paramKey = paramKey;
  }

  @JsonIgnore
  public MsConfigItemFieldModifyResponseResult paramCondition(String paramCondition) {
    this.paramCondition = paramCondition;
    return this;
  }

   /**
   * 权限字段条件
   * @return paramCondition
  **/
  @ApiModelProperty(value = "权限字段条件")
  public String getParamCondition() {
    return paramCondition;
  }

  public void setParamCondition(String paramCondition) {
    this.paramCondition = paramCondition;
  }

  @JsonIgnore
  public MsConfigItemFieldModifyResponseResult paramValue(String paramValue) {
    this.paramValue = paramValue;
    return this;
  }

   /**
   * 权限字段值
   * @return paramValue
  **/
  @ApiModelProperty(value = "权限字段值")
  public String getParamValue() {
    return paramValue;
  }

  public void setParamValue(String paramValue) {
    this.paramValue = paramValue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigItemFieldModifyResponseResult configItemFieldModifyResponseResult = (MsConfigItemFieldModifyResponseResult) o;
    return Objects.equals(this.controlLevel, configItemFieldModifyResponseResult.controlLevel) &&
        Objects.equals(this.paramKey, configItemFieldModifyResponseResult.paramKey) &&
        Objects.equals(this.paramCondition, configItemFieldModifyResponseResult.paramCondition) &&
        Objects.equals(this.paramValue, configItemFieldModifyResponseResult.paramValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(controlLevel, paramKey, paramCondition, paramValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigItemFieldModifyResponseResult {\n");
    
    sb.append("    controlLevel: ").append(toIndentedString(controlLevel)).append("\n");
    sb.append("    paramKey: ").append(toIndentedString(paramKey)).append("\n");
    sb.append("    paramCondition: ").append(toIndentedString(paramCondition)).append("\n");
    sb.append("    paramValue: ").append(toIndentedString(paramValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
