package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsCompanyList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 新建认证封锁
 */
@ApiModel(description = "新建认证封锁")

@JsonInclude(NON_NULL)
public class MsCreateAuthBlockRequest {
  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("groupName")
  private String groupName = null;

  @JsonProperty("blockRemark")
  private String blockRemark = null;

  @JsonProperty("companys")
  private List<MsCompanyList> companys = new ArrayList<MsCompanyList>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("overWrite")
  private String overWrite = null;

  @JsonProperty("createUserId")
  private Long createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonIgnore
  public MsCreateAuthBlockRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsCreateAuthBlockRequest groupName(String groupName) {
    this.groupName = groupName;
    return this;
  }

   /**
   * 集团名称
   * @return groupName
  **/
  @ApiModelProperty(value = "集团名称")
  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  @JsonIgnore
  public MsCreateAuthBlockRequest blockRemark(String blockRemark) {
    this.blockRemark = blockRemark;
    return this;
  }

   /**
   * 封锁备注
   * @return blockRemark
  **/
  @ApiModelProperty(value = "封锁备注")
  public String getBlockRemark() {
    return blockRemark;
  }

  public void setBlockRemark(String blockRemark) {
    this.blockRemark = blockRemark;
  }

  @JsonIgnore
  public MsCreateAuthBlockRequest companys(List<MsCompanyList> companys) {
    this.companys = companys;
    return this;
  }

  public MsCreateAuthBlockRequest addCompanysItem(MsCompanyList companysItem) {
    this.companys.add(companysItem);
    return this;
  }

   /**
   * 公司ID、税号、公司名称、组织id集合
   * @return companys
  **/
  @ApiModelProperty(value = "公司ID、税号、公司名称、组织id集合")
  public List<MsCompanyList> getCompanys() {
    return companys;
  }

  public void setCompanys(List<MsCompanyList> companys) {
    this.companys = companys;
  }

  @JsonIgnore
  public MsCreateAuthBlockRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态，1-未封锁，2-已封锁
   * @return status
  **/
  @ApiModelProperty(value = "状态，1-未封锁，2-已封锁")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsCreateAuthBlockRequest overWrite(String overWrite) {
    this.overWrite = overWrite;
    return this;
  }

   /**
   * 是否覆盖，false不覆盖，true覆盖
   * @return overWrite
  **/
  @ApiModelProperty(value = "是否覆盖，false不覆盖，true覆盖")
  public String getOverWrite() {
    return overWrite;
  }

  public void setOverWrite(String overWrite) {
    this.overWrite = overWrite;
  }

  @JsonIgnore
  public MsCreateAuthBlockRequest createUserId(Long createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建id
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建id")
  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsCreateAuthBlockRequest createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建名称
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建名称")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCreateAuthBlockRequest createAuthBlockRequest = (MsCreateAuthBlockRequest) o;
    return Objects.equals(this.groupId, createAuthBlockRequest.groupId) &&
        Objects.equals(this.groupName, createAuthBlockRequest.groupName) &&
        Objects.equals(this.blockRemark, createAuthBlockRequest.blockRemark) &&
        Objects.equals(this.companys, createAuthBlockRequest.companys) &&
        Objects.equals(this.status, createAuthBlockRequest.status) &&
        Objects.equals(this.overWrite, createAuthBlockRequest.overWrite) &&
        Objects.equals(this.createUserId, createAuthBlockRequest.createUserId) &&
        Objects.equals(this.createUserName, createAuthBlockRequest.createUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, groupName, blockRemark, companys, status, overWrite, createUserId, createUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCreateAuthBlockRequest {\n");
    
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    blockRemark: ").append(toIndentedString(blockRemark)).append("\n");
    sb.append("    companys: ").append(toIndentedString(companys)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    overWrite: ").append(toIndentedString(overWrite)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
