package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsCompanyList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 新建认证限额请求
 */
@ApiModel(description = "新建认证限额请求")

@JsonInclude(NON_NULL)
public class MsCreateAuthQuotaRequest {
  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("groupName")
  private String groupName = null;

  @JsonProperty("quotaMonths")
  private List<String> quotaMonths = new ArrayList<String>();

  @JsonProperty("companys")
  private List<MsCompanyList> companys = new ArrayList<MsCompanyList>();

  @JsonProperty("quota")
  private String quota = null;

  @JsonProperty("overWrite")
  private String overWrite = null;

  @JsonProperty("createId")
  private Long createId = null;

  @JsonProperty("createName")
  private String createName = null;

  @JsonIgnore
  public MsCreateAuthQuotaRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsCreateAuthQuotaRequest groupName(String groupName) {
    this.groupName = groupName;
    return this;
  }

   /**
   * 集团名称
   * @return groupName
  **/
  @ApiModelProperty(value = "集团名称")
  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  @JsonIgnore
  public MsCreateAuthQuotaRequest quotaMonths(List<String> quotaMonths) {
    this.quotaMonths = quotaMonths;
    return this;
  }

  public MsCreateAuthQuotaRequest addQuotaMonthsItem(String quotaMonthsItem) {
    this.quotaMonths.add(quotaMonthsItem);
    return this;
  }

   /**
   * 限额月份集合
   * @return quotaMonths
  **/
  @ApiModelProperty(value = "限额月份集合")
  public List<String> getQuotaMonths() {
    return quotaMonths;
  }

  public void setQuotaMonths(List<String> quotaMonths) {
    this.quotaMonths = quotaMonths;
  }

  @JsonIgnore
  public MsCreateAuthQuotaRequest companys(List<MsCompanyList> companys) {
    this.companys = companys;
    return this;
  }

  public MsCreateAuthQuotaRequest addCompanysItem(MsCompanyList companysItem) {
    this.companys.add(companysItem);
    return this;
  }

   /**
   * 公司ID、税号、公司名称、组织id集合
   * @return companys
  **/
  @ApiModelProperty(value = "公司ID、税号、公司名称、组织id集合")
  public List<MsCompanyList> getCompanys() {
    return companys;
  }

  public void setCompanys(List<MsCompanyList> companys) {
    this.companys = companys;
  }

  @JsonIgnore
  public MsCreateAuthQuotaRequest quota(String quota) {
    this.quota = quota;
    return this;
  }

   /**
   * 认证限额
   * @return quota
  **/
  @ApiModelProperty(value = "认证限额")
  public String getQuota() {
    return quota;
  }

  public void setQuota(String quota) {
    this.quota = quota;
  }

  @JsonIgnore
  public MsCreateAuthQuotaRequest overWrite(String overWrite) {
    this.overWrite = overWrite;
    return this;
  }

   /**
   * 是否覆盖，false不覆盖，true覆盖
   * @return overWrite
  **/
  @ApiModelProperty(value = "是否覆盖，false不覆盖，true覆盖")
  public String getOverWrite() {
    return overWrite;
  }

  public void setOverWrite(String overWrite) {
    this.overWrite = overWrite;
  }

  @JsonIgnore
  public MsCreateAuthQuotaRequest createId(Long createId) {
    this.createId = createId;
    return this;
  }

   /**
   * 创建id
   * @return createId
  **/
  @ApiModelProperty(value = "创建id")
  public Long getCreateId() {
    return createId;
  }

  public void setCreateId(Long createId) {
    this.createId = createId;
  }

  @JsonIgnore
  public MsCreateAuthQuotaRequest createName(String createName) {
    this.createName = createName;
    return this;
  }

   /**
   * 创建名称
   * @return createName
  **/
  @ApiModelProperty(value = "创建名称")
  public String getCreateName() {
    return createName;
  }

  public void setCreateName(String createName) {
    this.createName = createName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCreateAuthQuotaRequest createAuthQuotaRequest = (MsCreateAuthQuotaRequest) o;
    return Objects.equals(this.groupId, createAuthQuotaRequest.groupId) &&
        Objects.equals(this.groupName, createAuthQuotaRequest.groupName) &&
        Objects.equals(this.quotaMonths, createAuthQuotaRequest.quotaMonths) &&
        Objects.equals(this.companys, createAuthQuotaRequest.companys) &&
        Objects.equals(this.quota, createAuthQuotaRequest.quota) &&
        Objects.equals(this.overWrite, createAuthQuotaRequest.overWrite) &&
        Objects.equals(this.createId, createAuthQuotaRequest.createId) &&
        Objects.equals(this.createName, createAuthQuotaRequest.createName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, groupName, quotaMonths, companys, quota, overWrite, createId, createName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCreateAuthQuotaRequest {\n");
    
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    quotaMonths: ").append(toIndentedString(quotaMonths)).append("\n");
    sb.append("    companys: ").append(toIndentedString(companys)).append("\n");
    sb.append("    quota: ").append(toIndentedString(quota)).append("\n");
    sb.append("    overWrite: ").append(toIndentedString(overWrite)).append("\n");
    sb.append("    createId: ").append(toIndentedString(createId)).append("\n");
    sb.append("    createName: ").append(toIndentedString(createName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
