package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 自定义列模型
 */
@ApiModel(description = "自定义列模型")

@JsonInclude(NON_NULL)
public class MsCustomColumnModel {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("moduleNo")
  private Integer moduleNo = null;

  @JsonProperty("columnJson")
  private String columnJson = null;

  @JsonIgnore
  public MsCustomColumnModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsCustomColumnModel purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 集团id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsCustomColumnModel moduleNo(Integer moduleNo) {
    this.moduleNo = moduleNo;
    return this;
  }

   /**
   * 模块编号 0-默认，1-配单
   * @return moduleNo
  **/
  @ApiModelProperty(value = "模块编号 0-默认，1-配单")
  public Integer getModuleNo() {
    return moduleNo;
  }

  public void setModuleNo(Integer moduleNo) {
    this.moduleNo = moduleNo;
  }

  @JsonIgnore
  public MsCustomColumnModel columnJson(String columnJson) {
    this.columnJson = columnJson;
    return this;
  }

   /**
   * 自定义列json
   * @return columnJson
  **/
  @ApiModelProperty(value = "自定义列json")
  public String getColumnJson() {
    return columnJson;
  }

  public void setColumnJson(String columnJson) {
    this.columnJson = columnJson;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCustomColumnModel customColumnModel = (MsCustomColumnModel) o;
    return Objects.equals(this.id, customColumnModel.id) &&
        Objects.equals(this.purchaserGroupId, customColumnModel.purchaserGroupId) &&
        Objects.equals(this.moduleNo, customColumnModel.moduleNo) &&
        Objects.equals(this.columnJson, customColumnModel.columnJson);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, purchaserGroupId, moduleNo, columnJson);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCustomColumnModel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    moduleNo: ").append(toIndentedString(moduleNo)).append("\n");
    sb.append("    columnJson: ").append(toIndentedString(columnJson)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
