package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 删除认证限额
 */
@ApiModel(description = "删除认证限额")

@JsonInclude(NON_NULL)
public class MsDeleteAuthQuotaRequest {
  @JsonProperty("ids")
  private List<Long> ids = new ArrayList<Long>();

  @JsonProperty("updateId")
  private Long updateId = null;

  @JsonProperty("updateName")
  private String updateName = null;

  @JsonIgnore
  public MsDeleteAuthQuotaRequest ids(List<Long> ids) {
    this.ids = ids;
    return this;
  }

  public MsDeleteAuthQuotaRequest addIdsItem(Long idsItem) {
    this.ids.add(idsItem);
    return this;
  }

   /**
   * Get ids
   * @return ids
  **/
  @ApiModelProperty(value = "")
  public List<Long> getIds() {
    return ids;
  }

  public void setIds(List<Long> ids) {
    this.ids = ids;
  }

  @JsonIgnore
  public MsDeleteAuthQuotaRequest updateId(Long updateId) {
    this.updateId = updateId;
    return this;
  }

   /**
   * 更新id
   * @return updateId
  **/
  @ApiModelProperty(value = "更新id")
  public Long getUpdateId() {
    return updateId;
  }

  public void setUpdateId(Long updateId) {
    this.updateId = updateId;
  }

  @JsonIgnore
  public MsDeleteAuthQuotaRequest updateName(String updateName) {
    this.updateName = updateName;
    return this;
  }

   /**
   * 更新名称
   * @return updateName
  **/
  @ApiModelProperty(value = "更新名称")
  public String getUpdateName() {
    return updateName;
  }

  public void setUpdateName(String updateName) {
    this.updateName = updateName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDeleteAuthQuotaRequest deleteAuthQuotaRequest = (MsDeleteAuthQuotaRequest) o;
    return Objects.equals(this.ids, deleteAuthQuotaRequest.ids) &&
        Objects.equals(this.updateId, deleteAuthQuotaRequest.updateId) &&
        Objects.equals(this.updateName, deleteAuthQuotaRequest.updateName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ids, updateId, updateName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDeleteAuthQuotaRequest {\n");
    
    sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
    sb.append("    updateId: ").append(toIndentedString(updateId)).append("\n");
    sb.append("    updateName: ").append(toIndentedString(updateName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
