package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 删除配置组请求
 */
@ApiModel(description = "删除配置组请求")

@JsonInclude(NON_NULL)
public class MsDeleteConfigGroupRequest {
  @JsonProperty("configGroupIds")
  private List<Long> configGroupIds = new ArrayList<Long>();

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsDeleteConfigGroupRequest configGroupIds(List<Long> configGroupIds) {
    this.configGroupIds = configGroupIds;
    return this;
  }

  public MsDeleteConfigGroupRequest addConfigGroupIdsItem(Long configGroupIdsItem) {
    this.configGroupIds.add(configGroupIdsItem);
    return this;
  }

   /**
   * 配置组ID列表
   * @return configGroupIds
  **/
  @ApiModelProperty(value = "配置组ID列表")
  public List<Long> getConfigGroupIds() {
    return configGroupIds;
  }

  public void setConfigGroupIds(List<Long> configGroupIds) {
    this.configGroupIds = configGroupIds;
  }

  @JsonIgnore
  public MsDeleteConfigGroupRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDeleteConfigGroupRequest deleteConfigGroupRequest = (MsDeleteConfigGroupRequest) o;
    return Objects.equals(this.configGroupIds, deleteConfigGroupRequest.configGroupIds) &&
        Objects.equals(this.userInfo, deleteConfigGroupRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configGroupIds, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDeleteConfigGroupRequest {\n");
    
    sb.append("    configGroupIds: ").append(toIndentedString(configGroupIds)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
