package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 删除商品信息请求
 */
@ApiModel(description = "删除商品信息请求")

@JsonInclude(NON_NULL)
public class MsDeleteGoodsRequest {
  @JsonProperty("goodsIds")
  private List<Long> goodsIds = new ArrayList<Long>();

  @JsonIgnore
  public MsDeleteGoodsRequest goodsIds(List<Long> goodsIds) {
    this.goodsIds = goodsIds;
    return this;
  }

  public MsDeleteGoodsRequest addGoodsIdsItem(Long goodsIdsItem) {
    this.goodsIds.add(goodsIdsItem);
    return this;
  }

   /**
   * 商品主键集合
   * @return goodsIds
  **/
  @ApiModelProperty(value = "商品主键集合")
  public List<Long> getGoodsIds() {
    return goodsIds;
  }

  public void setGoodsIds(List<Long> goodsIds) {
    this.goodsIds = goodsIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDeleteGoodsRequest deleteGoodsRequest = (MsDeleteGoodsRequest) o;
    return Objects.equals(this.goodsIds, deleteGoodsRequest.goodsIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDeleteGoodsRequest {\n");
    
    sb.append("    goodsIds: ").append(toIndentedString(goodsIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
