package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 删除请求
 */
@ApiModel(description = "删除请求")

@JsonInclude(NON_NULL)
public class MsDeleteSimpleCollectionRequest {
  @JsonProperty("ids")
  private List<Long> ids = new ArrayList<Long>();

  @JsonIgnore
  public MsDeleteSimpleCollectionRequest ids(List<Long> ids) {
    this.ids = ids;
    return this;
  }

  public MsDeleteSimpleCollectionRequest addIdsItem(Long idsItem) {
    this.ids.add(idsItem);
    return this;
  }

   /**
   * id集合
   * @return ids
  **/
  @ApiModelProperty(value = "id集合")
  public List<Long> getIds() {
    return ids;
  }

  public void setIds(List<Long> ids) {
    this.ids = ids;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDeleteSimpleCollectionRequest deleteSimpleCollectionRequest = (MsDeleteSimpleCollectionRequest) o;
    return Objects.equals(this.ids, deleteSimpleCollectionRequest.ids);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ids);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDeleteSimpleCollectionRequest {\n");
    
    sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
