package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 生效范围(企业信息)
 */
@ApiModel(description = "生效范围(企业信息)")

@JsonInclude(NON_NULL)
public class MsEffectRange {
  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonIgnore
  public MsEffectRange companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 企业ID
   * @return companyId
  **/
  @ApiModelProperty(value = "企业ID")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsEffectRange companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 企业名称
   * @return companyName
  **/
  @ApiModelProperty(value = "企业名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsEffectRange effectRange = (MsEffectRange) o;
    return Objects.equals(this.companyId, effectRange.companyId) &&
        Objects.equals(this.companyName, effectRange.companyName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, companyName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsEffectRange {\n");
    
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
