package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsExcelImportResult {
  @JsonProperty("totalCount")
  private Integer totalCount = null;

  @JsonProperty("successCount")
  private Integer successCount = null;

  @JsonProperty("failCount")
  private Integer failCount = null;

  @JsonIgnore
  public MsExcelImportResult totalCount(Integer totalCount) {
    this.totalCount = totalCount;
    return this;
  }

   /**
   * 总数量
   * @return totalCount
  **/
  @ApiModelProperty(value = "总数量")
  public Integer getTotalCount() {
    return totalCount;
  }

  public void setTotalCount(Integer totalCount) {
    this.totalCount = totalCount;
  }

  @JsonIgnore
  public MsExcelImportResult successCount(Integer successCount) {
    this.successCount = successCount;
    return this;
  }

   /**
   * 成功数量
   * @return successCount
  **/
  @ApiModelProperty(value = "成功数量")
  public Integer getSuccessCount() {
    return successCount;
  }

  public void setSuccessCount(Integer successCount) {
    this.successCount = successCount;
  }

  @JsonIgnore
  public MsExcelImportResult failCount(Integer failCount) {
    this.failCount = failCount;
    return this;
  }

   /**
   * 失败数量
   * @return failCount
  **/
  @ApiModelProperty(value = "失败数量")
  public Integer getFailCount() {
    return failCount;
  }

  public void setFailCount(Integer failCount) {
    this.failCount = failCount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsExcelImportResult excelImportResult = (MsExcelImportResult) o;
    return Objects.equals(this.totalCount, excelImportResult.totalCount) &&
        Objects.equals(this.successCount, excelImportResult.successCount) &&
        Objects.equals(this.failCount, excelImportResult.failCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalCount, successCount, failCount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsExcelImportResult {\n");
    
    sb.append("    totalCount: ").append(toIndentedString(totalCount)).append("\n");
    sb.append("    successCount: ").append(toIndentedString(successCount)).append("\n");
    sb.append("    failCount: ").append(toIndentedString(failCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
