package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 系统通用字段配置对象
 */
@ApiModel(description = "系统通用字段配置对象")

@JsonInclude(NON_NULL)
public class MsFieldConfigCommon {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("tableName")
  private String tableName = null;

  @JsonProperty("columnName")
  private String columnName = null;

  @JsonProperty("columnCamelName")
  private String columnCamelName = null;

  @JsonProperty("columnNameCn")
  private String columnNameCn = null;

  @JsonProperty("componentType")
  private Integer componentType = null;

  @JsonProperty("searchType")
  private String searchType = null;

  @JsonProperty("groupCode")
  private String groupCode = null;

  @JsonProperty("isExt")
  private Integer isExt = null;

  @JsonProperty("isView")
  private Integer isView = null;

  @JsonProperty("isSearch")
  private Integer isSearch = null;

  @JsonProperty("isExport")
  private Integer isExport = null;

  @JsonProperty("isEdit")
  private Integer isEdit = null;

  @JsonProperty("isEnable")
  private Integer isEnable = null;

  @JsonProperty("isDelete")
  private Integer isDelete = null;

  @JsonProperty("createName")
  private String createName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("createId")
  private Long createId = null;

  @JsonProperty("updateName")
  private String updateName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonProperty("updateId")
  private Long updateId = null;

  @JsonIgnore
  public MsFieldConfigCommon id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsFieldConfigCommon tableName(String tableName) {
    this.tableName = tableName;
    return this;
  }

   /**
   * 表名
   * @return tableName
  **/
  @ApiModelProperty(value = "表名")
  public String getTableName() {
    return tableName;
  }

  public void setTableName(String tableName) {
    this.tableName = tableName;
  }

  @JsonIgnore
  public MsFieldConfigCommon columnName(String columnName) {
    this.columnName = columnName;
    return this;
  }

   /**
   * 数据库字段名
   * @return columnName
  **/
  @ApiModelProperty(value = "数据库字段名")
  public String getColumnName() {
    return columnName;
  }

  public void setColumnName(String columnName) {
    this.columnName = columnName;
  }

  @JsonIgnore
  public MsFieldConfigCommon columnCamelName(String columnCamelName) {
    this.columnCamelName = columnCamelName;
    return this;
  }

   /**
   * 驼峰名
   * @return columnCamelName
  **/
  @ApiModelProperty(value = "驼峰名")
  public String getColumnCamelName() {
    return columnCamelName;
  }

  public void setColumnCamelName(String columnCamelName) {
    this.columnCamelName = columnCamelName;
  }

  @JsonIgnore
  public MsFieldConfigCommon columnNameCn(String columnNameCn) {
    this.columnNameCn = columnNameCn;
    return this;
  }

   /**
   * 中文名
   * @return columnNameCn
  **/
  @ApiModelProperty(value = "中文名")
  public String getColumnNameCn() {
    return columnNameCn;
  }

  public void setColumnNameCn(String columnNameCn) {
    this.columnNameCn = columnNameCn;
  }

  @JsonIgnore
  public MsFieldConfigCommon componentType(Integer componentType) {
    this.componentType = componentType;
    return this;
  }

   /**
   * 组件类型
   * @return componentType
  **/
  @ApiModelProperty(value = "组件类型")
  public Integer getComponentType() {
    return componentType;
  }

  public void setComponentType(Integer componentType) {
    this.componentType = componentType;
  }

  @JsonIgnore
  public MsFieldConfigCommon searchType(String searchType) {
    this.searchType = searchType;
    return this;
  }

   /**
   * 查询方式
   * @return searchType
  **/
  @ApiModelProperty(value = "查询方式")
  public String getSearchType() {
    return searchType;
  }

  public void setSearchType(String searchType) {
    this.searchType = searchType;
  }

  @JsonIgnore
  public MsFieldConfigCommon groupCode(String groupCode) {
    this.groupCode = groupCode;
    return this;
  }

   /**
   * 字典表分组(comm_code.group_code)
   * @return groupCode
  **/
  @ApiModelProperty(value = "字典表分组(comm_code.group_code)")
  public String getGroupCode() {
    return groupCode;
  }

  public void setGroupCode(String groupCode) {
    this.groupCode = groupCode;
  }

  @JsonIgnore
  public MsFieldConfigCommon isExt(Integer isExt) {
    this.isExt = isExt;
    return this;
  }

   /**
   * (1基础字段，0扩展字段）
   * @return isExt
  **/
  @ApiModelProperty(value = "(1基础字段，0扩展字段）")
  public Integer getIsExt() {
    return isExt;
  }

  public void setIsExt(Integer isExt) {
    this.isExt = isExt;
  }

  @JsonIgnore
  public MsFieldConfigCommon isView(Integer isView) {
    this.isView = isView;
    return this;
  }

   /**
   * 是否可展示（1可展示 0 不可展示）
   * @return isView
  **/
  @ApiModelProperty(value = "是否可展示（1可展示 0 不可展示）")
  public Integer getIsView() {
    return isView;
  }

  public void setIsView(Integer isView) {
    this.isView = isView;
  }

  @JsonIgnore
  public MsFieldConfigCommon isSearch(Integer isSearch) {
    this.isSearch = isSearch;
    return this;
  }

   /**
   * 是否可查询（1 可查询  0 不可查询）
   * @return isSearch
  **/
  @ApiModelProperty(value = "是否可查询（1 可查询  0 不可查询）")
  public Integer getIsSearch() {
    return isSearch;
  }

  public void setIsSearch(Integer isSearch) {
    this.isSearch = isSearch;
  }

  @JsonIgnore
  public MsFieldConfigCommon isExport(Integer isExport) {
    this.isExport = isExport;
    return this;
  }

   /**
   * 是否可导出（1 可查询  0 不可查询）
   * @return isExport
  **/
  @ApiModelProperty(value = "是否可导出（1 可查询  0 不可查询）")
  public Integer getIsExport() {
    return isExport;
  }

  public void setIsExport(Integer isExport) {
    this.isExport = isExport;
  }

  @JsonIgnore
  public MsFieldConfigCommon isEdit(Integer isEdit) {
    this.isEdit = isEdit;
    return this;
  }

   /**
   * 是否可编辑（控制此字段是否支持在“修改扩展信息”按钮中修改）
   * @return isEdit
  **/
  @ApiModelProperty(value = "是否可编辑（控制此字段是否支持在“修改扩展信息”按钮中修改）")
  public Integer getIsEdit() {
    return isEdit;
  }

  public void setIsEdit(Integer isEdit) {
    this.isEdit = isEdit;
  }

  @JsonIgnore
  public MsFieldConfigCommon isEnable(Integer isEnable) {
    this.isEnable = isEnable;
    return this;
  }

   /**
   * 是否启用（1启用 0不启用）
   * @return isEnable
  **/
  @ApiModelProperty(value = "是否启用（1启用 0不启用）")
  public Integer getIsEnable() {
    return isEnable;
  }

  public void setIsEnable(Integer isEnable) {
    this.isEnable = isEnable;
  }

  @JsonIgnore
  public MsFieldConfigCommon isDelete(Integer isDelete) {
    this.isDelete = isDelete;
    return this;
  }

   /**
   * 是否删除（1有效 0删除）
   * @return isDelete
  **/
  @ApiModelProperty(value = "是否删除（1有效 0删除）")
  public Integer getIsDelete() {
    return isDelete;
  }

  public void setIsDelete(Integer isDelete) {
    this.isDelete = isDelete;
  }

  @JsonIgnore
  public MsFieldConfigCommon createName(String createName) {
    this.createName = createName;
    return this;
  }

   /**
   * 创建人
   * @return createName
  **/
  @ApiModelProperty(value = "创建人")
  public String getCreateName() {
    return createName;
  }

  public void setCreateName(String createName) {
    this.createName = createName;
  }

  @JsonIgnore
  public MsFieldConfigCommon createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsFieldConfigCommon createId(Long createId) {
    this.createId = createId;
    return this;
  }

   /**
   * 创建人ID
   * @return createId
  **/
  @ApiModelProperty(value = "创建人ID")
  public Long getCreateId() {
    return createId;
  }

  public void setCreateId(Long createId) {
    this.createId = createId;
  }

  @JsonIgnore
  public MsFieldConfigCommon updateName(String updateName) {
    this.updateName = updateName;
    return this;
  }

   /**
   * 更新人
   * @return updateName
  **/
  @ApiModelProperty(value = "更新人")
  public String getUpdateName() {
    return updateName;
  }

  public void setUpdateName(String updateName) {
    this.updateName = updateName;
  }

  @JsonIgnore
  public MsFieldConfigCommon updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public MsFieldConfigCommon updateId(Long updateId) {
    this.updateId = updateId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateId
  **/
  @ApiModelProperty(value = "更新人ID")
  public Long getUpdateId() {
    return updateId;
  }

  public void setUpdateId(Long updateId) {
    this.updateId = updateId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFieldConfigCommon fieldConfigCommon = (MsFieldConfigCommon) o;
    return Objects.equals(this.id, fieldConfigCommon.id) &&
        Objects.equals(this.tableName, fieldConfigCommon.tableName) &&
        Objects.equals(this.columnName, fieldConfigCommon.columnName) &&
        Objects.equals(this.columnCamelName, fieldConfigCommon.columnCamelName) &&
        Objects.equals(this.columnNameCn, fieldConfigCommon.columnNameCn) &&
        Objects.equals(this.componentType, fieldConfigCommon.componentType) &&
        Objects.equals(this.searchType, fieldConfigCommon.searchType) &&
        Objects.equals(this.groupCode, fieldConfigCommon.groupCode) &&
        Objects.equals(this.isExt, fieldConfigCommon.isExt) &&
        Objects.equals(this.isView, fieldConfigCommon.isView) &&
        Objects.equals(this.isSearch, fieldConfigCommon.isSearch) &&
        Objects.equals(this.isExport, fieldConfigCommon.isExport) &&
        Objects.equals(this.isEdit, fieldConfigCommon.isEdit) &&
        Objects.equals(this.isEnable, fieldConfigCommon.isEnable) &&
        Objects.equals(this.isDelete, fieldConfigCommon.isDelete) &&
        Objects.equals(this.createName, fieldConfigCommon.createName) &&
        Objects.equals(this.createTime, fieldConfigCommon.createTime) &&
        Objects.equals(this.createId, fieldConfigCommon.createId) &&
        Objects.equals(this.updateName, fieldConfigCommon.updateName) &&
        Objects.equals(this.updateTime, fieldConfigCommon.updateTime) &&
        Objects.equals(this.updateId, fieldConfigCommon.updateId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, tableName, columnName, columnCamelName, columnNameCn, componentType, searchType, groupCode, isExt, isView, isSearch, isExport, isEdit, isEnable, isDelete, createName, createTime, createId, updateName, updateTime, updateId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFieldConfigCommon {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    tableName: ").append(toIndentedString(tableName)).append("\n");
    sb.append("    columnName: ").append(toIndentedString(columnName)).append("\n");
    sb.append("    columnCamelName: ").append(toIndentedString(columnCamelName)).append("\n");
    sb.append("    columnNameCn: ").append(toIndentedString(columnNameCn)).append("\n");
    sb.append("    componentType: ").append(toIndentedString(componentType)).append("\n");
    sb.append("    searchType: ").append(toIndentedString(searchType)).append("\n");
    sb.append("    groupCode: ").append(toIndentedString(groupCode)).append("\n");
    sb.append("    isExt: ").append(toIndentedString(isExt)).append("\n");
    sb.append("    isView: ").append(toIndentedString(isView)).append("\n");
    sb.append("    isSearch: ").append(toIndentedString(isSearch)).append("\n");
    sb.append("    isExport: ").append(toIndentedString(isExport)).append("\n");
    sb.append("    isEdit: ").append(toIndentedString(isEdit)).append("\n");
    sb.append("    isEnable: ").append(toIndentedString(isEnable)).append("\n");
    sb.append("    isDelete: ").append(toIndentedString(isDelete)).append("\n");
    sb.append("    createName: ").append(toIndentedString(createName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    createId: ").append(toIndentedString(createId)).append("\n");
    sb.append("    updateName: ").append(toIndentedString(updateName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    updateId: ").append(toIndentedString(updateId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
