package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取系统通用字段配置查询入参
 */
@ApiModel(description = "获取系统通用字段配置查询入参")

@JsonInclude(NON_NULL)
public class MsFieldConfigCommonQueryRequest {
  @JsonProperty("isExt")
  private Integer isExt = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsFieldConfigCommonQueryRequest isExt(Integer isExt) {
    this.isExt = isExt;
    return this;
  }

   /**
   * 1基础字段，0扩展字段
   * @return isExt
  **/
  @ApiModelProperty(value = "1基础字段，0扩展字段")
  public Integer getIsExt() {
    return isExt;
  }

  public void setIsExt(Integer isExt) {
    this.isExt = isExt;
  }

  @JsonIgnore
  public MsFieldConfigCommonQueryRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * Get userInfo
   * @return userInfo
  **/
  @ApiModelProperty(value = "")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFieldConfigCommonQueryRequest fieldConfigCommonQueryRequest = (MsFieldConfigCommonQueryRequest) o;
    return Objects.equals(this.isExt, fieldConfigCommonQueryRequest.isExt) &&
        Objects.equals(this.userInfo, fieldConfigCommonQueryRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isExt, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFieldConfigCommonQueryRequest {\n");
    
    sb.append("    isExt: ").append(toIndentedString(isExt)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
