package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsFieldConfigCommon;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 系统通用字段配置
 */
@ApiModel(description = "系统通用字段配置")

@JsonInclude(NON_NULL)
public class MsFieldConfigCommonResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsFieldConfigCommon> result = new ArrayList<MsFieldConfigCommon>();

  @JsonIgnore
  public MsFieldConfigCommonResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 0-失败，1-成功
   * @return code
  **/
  @ApiModelProperty(value = "0-失败，1-成功")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsFieldConfigCommonResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsFieldConfigCommonResponse result(List<MsFieldConfigCommon> result) {
    this.result = result;
    return this;
  }

  public MsFieldConfigCommonResponse addResultItem(MsFieldConfigCommon resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 反馈数据
   * @return result
  **/
  @ApiModelProperty(value = "反馈数据")
  public List<MsFieldConfigCommon> getResult() {
    return result;
  }

  public void setResult(List<MsFieldConfigCommon> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFieldConfigCommonResponse fieldConfigCommonResponse = (MsFieldConfigCommonResponse) o;
    return Objects.equals(this.code, fieldConfigCommonResponse.code) &&
        Objects.equals(this.message, fieldConfigCommonResponse.message) &&
        Objects.equals(this.result, fieldConfigCommonResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFieldConfigCommonResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
