package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 租户维度配置字段对象
 */
@ApiModel(description = "租户维度配置字段对象")

@JsonInclude(NON_NULL)
public class MsFieldConfigGroup {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("commonIdFk")
  private Long commonIdFk = null;

  @JsonProperty("extName")
  private String extName = null;

  @JsonProperty("isExt")
  private Integer isExt = null;

  @JsonProperty("columnCamelName")
  private String columnCamelName = null;

  @JsonProperty("componentType")
  private Integer componentType = null;

  @JsonProperty("searchType")
  private String searchType = null;

  @JsonProperty("groupCode")
  private String groupCode = null;

  @JsonProperty("isView")
  private Integer isView = null;

  @JsonProperty("isSearch")
  private Integer isSearch = null;

  @JsonProperty("isExport")
  private Integer isExport = null;

  @JsonProperty("isEdit")
  private Integer isEdit = null;

  @JsonProperty("isEnable")
  private Integer isEnable = null;

  @JsonProperty("isDelete")
  private Integer isDelete = null;

  @JsonProperty("isCover")
  private Integer isCover = null;

  @JsonProperty("createName")
  private String createName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("createId")
  private Long createId = null;

  @JsonProperty("updateName")
  private String updateName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonProperty("updateId")
  private Long updateId = null;

  @JsonIgnore
  public MsFieldConfigGroup id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsFieldConfigGroup tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsFieldConfigGroup commonIdFk(Long commonIdFk) {
    this.commonIdFk = commonIdFk;
    return this;
  }

   /**
   * 基础字段ID外键
   * @return commonIdFk
  **/
  @ApiModelProperty(value = "基础字段ID外键")
  public Long getCommonIdFk() {
    return commonIdFk;
  }

  public void setCommonIdFk(Long commonIdFk) {
    this.commonIdFk = commonIdFk;
  }

  @JsonIgnore
  public MsFieldConfigGroup extName(String extName) {
    this.extName = extName;
    return this;
  }

   /**
   * 字段展示名
   * @return extName
  **/
  @ApiModelProperty(value = "字段展示名")
  public String getExtName() {
    return extName;
  }

  public void setExtName(String extName) {
    this.extName = extName;
  }

  @JsonIgnore
  public MsFieldConfigGroup isExt(Integer isExt) {
    this.isExt = isExt;
    return this;
  }

   /**
   * (1基础字段，0扩展字段）
   * @return isExt
  **/
  @ApiModelProperty(value = "(1基础字段，0扩展字段）")
  public Integer getIsExt() {
    return isExt;
  }

  public void setIsExt(Integer isExt) {
    this.isExt = isExt;
  }

  @JsonIgnore
  public MsFieldConfigGroup columnCamelName(String columnCamelName) {
    this.columnCamelName = columnCamelName;
    return this;
  }

   /**
   * 驼峰名
   * @return columnCamelName
  **/
  @ApiModelProperty(value = "驼峰名")
  public String getColumnCamelName() {
    return columnCamelName;
  }

  public void setColumnCamelName(String columnCamelName) {
    this.columnCamelName = columnCamelName;
  }

  @JsonIgnore
  public MsFieldConfigGroup componentType(Integer componentType) {
    this.componentType = componentType;
    return this;
  }

   /**
   * 组件类型
   * @return componentType
  **/
  @ApiModelProperty(value = "组件类型")
  public Integer getComponentType() {
    return componentType;
  }

  public void setComponentType(Integer componentType) {
    this.componentType = componentType;
  }

  @JsonIgnore
  public MsFieldConfigGroup searchType(String searchType) {
    this.searchType = searchType;
    return this;
  }

   /**
   * 查询方式
   * @return searchType
  **/
  @ApiModelProperty(value = "查询方式")
  public String getSearchType() {
    return searchType;
  }

  public void setSearchType(String searchType) {
    this.searchType = searchType;
  }

  @JsonIgnore
  public MsFieldConfigGroup groupCode(String groupCode) {
    this.groupCode = groupCode;
    return this;
  }

   /**
   * 字典表分组(comm_code.group_code)
   * @return groupCode
  **/
  @ApiModelProperty(value = "字典表分组(comm_code.group_code)")
  public String getGroupCode() {
    return groupCode;
  }

  public void setGroupCode(String groupCode) {
    this.groupCode = groupCode;
  }

  @JsonIgnore
  public MsFieldConfigGroup isView(Integer isView) {
    this.isView = isView;
    return this;
  }

   /**
   * 是否可展示（1可展示 0 不可展示）
   * @return isView
  **/
  @ApiModelProperty(value = "是否可展示（1可展示 0 不可展示）")
  public Integer getIsView() {
    return isView;
  }

  public void setIsView(Integer isView) {
    this.isView = isView;
  }

  @JsonIgnore
  public MsFieldConfigGroup isSearch(Integer isSearch) {
    this.isSearch = isSearch;
    return this;
  }

   /**
   * 是否可查询（1 可查询  0 不可查询）
   * @return isSearch
  **/
  @ApiModelProperty(value = "是否可查询（1 可查询  0 不可查询）")
  public Integer getIsSearch() {
    return isSearch;
  }

  public void setIsSearch(Integer isSearch) {
    this.isSearch = isSearch;
  }

  @JsonIgnore
  public MsFieldConfigGroup isExport(Integer isExport) {
    this.isExport = isExport;
    return this;
  }

   /**
   * 是否可导出（1 可查询  0 不可查询）
   * @return isExport
  **/
  @ApiModelProperty(value = "是否可导出（1 可查询  0 不可查询）")
  public Integer getIsExport() {
    return isExport;
  }

  public void setIsExport(Integer isExport) {
    this.isExport = isExport;
  }

  @JsonIgnore
  public MsFieldConfigGroup isEdit(Integer isEdit) {
    this.isEdit = isEdit;
    return this;
  }

   /**
   * 是否可编辑（控制此字段是否支持在“修改扩展信息”按钮中修改）
   * @return isEdit
  **/
  @ApiModelProperty(value = "是否可编辑（控制此字段是否支持在“修改扩展信息”按钮中修改）")
  public Integer getIsEdit() {
    return isEdit;
  }

  public void setIsEdit(Integer isEdit) {
    this.isEdit = isEdit;
  }

  @JsonIgnore
  public MsFieldConfigGroup isEnable(Integer isEnable) {
    this.isEnable = isEnable;
    return this;
  }

   /**
   * 是否启用（1启用 0不启用）
   * @return isEnable
  **/
  @ApiModelProperty(value = "是否启用（1启用 0不启用）")
  public Integer getIsEnable() {
    return isEnable;
  }

  public void setIsEnable(Integer isEnable) {
    this.isEnable = isEnable;
  }

  @JsonIgnore
  public MsFieldConfigGroup isDelete(Integer isDelete) {
    this.isDelete = isDelete;
    return this;
  }

   /**
   * 是否删除（1有效 0删除）
   * @return isDelete
  **/
  @ApiModelProperty(value = "是否删除（1有效 0删除）")
  public Integer getIsDelete() {
    return isDelete;
  }

  public void setIsDelete(Integer isDelete) {
    this.isDelete = isDelete;
  }

  @JsonIgnore
  public MsFieldConfigGroup isCover(Integer isCover) {
    this.isCover = isCover;
    return this;
  }

   /**
   * 是否可以被覆盖（1可覆盖，0不可覆盖）（为了应对销项过来的扩展字段）
   * @return isCover
  **/
  @ApiModelProperty(value = "是否可以被覆盖（1可覆盖，0不可覆盖）（为了应对销项过来的扩展字段）")
  public Integer getIsCover() {
    return isCover;
  }

  public void setIsCover(Integer isCover) {
    this.isCover = isCover;
  }

  @JsonIgnore
  public MsFieldConfigGroup createName(String createName) {
    this.createName = createName;
    return this;
  }

   /**
   * 创建人
   * @return createName
  **/
  @ApiModelProperty(value = "创建人")
  public String getCreateName() {
    return createName;
  }

  public void setCreateName(String createName) {
    this.createName = createName;
  }

  @JsonIgnore
  public MsFieldConfigGroup createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsFieldConfigGroup createId(Long createId) {
    this.createId = createId;
    return this;
  }

   /**
   * 创建人ID
   * @return createId
  **/
  @ApiModelProperty(value = "创建人ID")
  public Long getCreateId() {
    return createId;
  }

  public void setCreateId(Long createId) {
    this.createId = createId;
  }

  @JsonIgnore
  public MsFieldConfigGroup updateName(String updateName) {
    this.updateName = updateName;
    return this;
  }

   /**
   * 更新人
   * @return updateName
  **/
  @ApiModelProperty(value = "更新人")
  public String getUpdateName() {
    return updateName;
  }

  public void setUpdateName(String updateName) {
    this.updateName = updateName;
  }

  @JsonIgnore
  public MsFieldConfigGroup updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public MsFieldConfigGroup updateId(Long updateId) {
    this.updateId = updateId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateId
  **/
  @ApiModelProperty(value = "更新人ID")
  public Long getUpdateId() {
    return updateId;
  }

  public void setUpdateId(Long updateId) {
    this.updateId = updateId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFieldConfigGroup fieldConfigGroup = (MsFieldConfigGroup) o;
    return Objects.equals(this.id, fieldConfigGroup.id) &&
        Objects.equals(this.tenantId, fieldConfigGroup.tenantId) &&
        Objects.equals(this.commonIdFk, fieldConfigGroup.commonIdFk) &&
        Objects.equals(this.extName, fieldConfigGroup.extName) &&
        Objects.equals(this.isExt, fieldConfigGroup.isExt) &&
        Objects.equals(this.columnCamelName, fieldConfigGroup.columnCamelName) &&
        Objects.equals(this.componentType, fieldConfigGroup.componentType) &&
        Objects.equals(this.searchType, fieldConfigGroup.searchType) &&
        Objects.equals(this.groupCode, fieldConfigGroup.groupCode) &&
        Objects.equals(this.isView, fieldConfigGroup.isView) &&
        Objects.equals(this.isSearch, fieldConfigGroup.isSearch) &&
        Objects.equals(this.isExport, fieldConfigGroup.isExport) &&
        Objects.equals(this.isEdit, fieldConfigGroup.isEdit) &&
        Objects.equals(this.isEnable, fieldConfigGroup.isEnable) &&
        Objects.equals(this.isDelete, fieldConfigGroup.isDelete) &&
        Objects.equals(this.isCover, fieldConfigGroup.isCover) &&
        Objects.equals(this.createName, fieldConfigGroup.createName) &&
        Objects.equals(this.createTime, fieldConfigGroup.createTime) &&
        Objects.equals(this.createId, fieldConfigGroup.createId) &&
        Objects.equals(this.updateName, fieldConfigGroup.updateName) &&
        Objects.equals(this.updateTime, fieldConfigGroup.updateTime) &&
        Objects.equals(this.updateId, fieldConfigGroup.updateId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, tenantId, commonIdFk, extName, isExt, columnCamelName, componentType, searchType, groupCode, isView, isSearch, isExport, isEdit, isEnable, isDelete, isCover, createName, createTime, createId, updateName, updateTime, updateId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFieldConfigGroup {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    commonIdFk: ").append(toIndentedString(commonIdFk)).append("\n");
    sb.append("    extName: ").append(toIndentedString(extName)).append("\n");
    sb.append("    isExt: ").append(toIndentedString(isExt)).append("\n");
    sb.append("    columnCamelName: ").append(toIndentedString(columnCamelName)).append("\n");
    sb.append("    componentType: ").append(toIndentedString(componentType)).append("\n");
    sb.append("    searchType: ").append(toIndentedString(searchType)).append("\n");
    sb.append("    groupCode: ").append(toIndentedString(groupCode)).append("\n");
    sb.append("    isView: ").append(toIndentedString(isView)).append("\n");
    sb.append("    isSearch: ").append(toIndentedString(isSearch)).append("\n");
    sb.append("    isExport: ").append(toIndentedString(isExport)).append("\n");
    sb.append("    isEdit: ").append(toIndentedString(isEdit)).append("\n");
    sb.append("    isEnable: ").append(toIndentedString(isEnable)).append("\n");
    sb.append("    isDelete: ").append(toIndentedString(isDelete)).append("\n");
    sb.append("    isCover: ").append(toIndentedString(isCover)).append("\n");
    sb.append("    createName: ").append(toIndentedString(createName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    createId: ").append(toIndentedString(createId)).append("\n");
    sb.append("    updateName: ").append(toIndentedString(updateName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    updateId: ").append(toIndentedString(updateId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
