package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取租户维度字段配置查询入参
 */
@ApiModel(description = "获取租户维度字段配置查询入参")

@JsonInclude(NON_NULL)
public class MsFieldConfigGroupQueryRequest {
  @JsonProperty("fieldName")
  private String fieldName = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsFieldConfigGroupQueryRequest fieldName(String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

   /**
   * 字段中文名称
   * @return fieldName
  **/
  @ApiModelProperty(value = "字段中文名称")
  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  @JsonIgnore
  public MsFieldConfigGroupQueryRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * Get userInfo
   * @return userInfo
  **/
  @ApiModelProperty(value = "")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFieldConfigGroupQueryRequest fieldConfigGroupQueryRequest = (MsFieldConfigGroupQueryRequest) o;
    return Objects.equals(this.fieldName, fieldConfigGroupQueryRequest.fieldName) &&
        Objects.equals(this.userInfo, fieldConfigGroupQueryRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldName, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFieldConfigGroupQueryRequest {\n");
    
    sb.append("    fieldName: ").append(toIndentedString(fieldName)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
