package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsCommonCode;
import com.xforceplus.purconfig.client.model.MsFieldConfigGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 租户维度保存请求
 */
@ApiModel(description = "租户维度保存请求")

@JsonInclude(NON_NULL)
public class MsFieldConfigGroupRequest {
  @JsonProperty("fieldConfigGroupData")
  private MsFieldConfigGroup fieldConfigGroupData = null;

  @JsonProperty("commonCodes")
  private List<MsCommonCode> commonCodes = new ArrayList<MsCommonCode>();

  @JsonIgnore
  public MsFieldConfigGroupRequest fieldConfigGroupData(MsFieldConfigGroup fieldConfigGroupData) {
    this.fieldConfigGroupData = fieldConfigGroupData;
    return this;
  }

   /**
   * 租户维度配置对象
   * @return fieldConfigGroupData
  **/
  @ApiModelProperty(value = "租户维度配置对象")
  public MsFieldConfigGroup getFieldConfigGroupData() {
    return fieldConfigGroupData;
  }

  public void setFieldConfigGroupData(MsFieldConfigGroup fieldConfigGroupData) {
    this.fieldConfigGroupData = fieldConfigGroupData;
  }

  @JsonIgnore
  public MsFieldConfigGroupRequest commonCodes(List<MsCommonCode> commonCodes) {
    this.commonCodes = commonCodes;
    return this;
  }

  public MsFieldConfigGroupRequest addCommonCodesItem(MsCommonCode commonCodesItem) {
    this.commonCodes.add(commonCodesItem);
    return this;
  }

   /**
   * 枚举对象集合
   * @return commonCodes
  **/
  @ApiModelProperty(value = "枚举对象集合")
  public List<MsCommonCode> getCommonCodes() {
    return commonCodes;
  }

  public void setCommonCodes(List<MsCommonCode> commonCodes) {
    this.commonCodes = commonCodes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFieldConfigGroupRequest fieldConfigGroupRequest = (MsFieldConfigGroupRequest) o;
    return Objects.equals(this.fieldConfigGroupData, fieldConfigGroupRequest.fieldConfigGroupData) &&
        Objects.equals(this.commonCodes, fieldConfigGroupRequest.commonCodes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldConfigGroupData, commonCodes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFieldConfigGroupRequest {\n");
    
    sb.append("    fieldConfigGroupData: ").append(toIndentedString(fieldConfigGroupData)).append("\n");
    sb.append("    commonCodes: ").append(toIndentedString(commonCodes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
