package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsFieldConfigGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取租户维度字段配置响应对象
 */
@ApiModel(description = "获取租户维度字段配置响应对象")

@JsonInclude(NON_NULL)
public class MsFieldConfigGroupResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsFieldConfigGroup> result = new ArrayList<MsFieldConfigGroup>();

  @JsonIgnore
  public MsFieldConfigGroupResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 0-失败，1-成功
   * @return code
  **/
  @ApiModelProperty(value = "0-失败，1-成功")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsFieldConfigGroupResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsFieldConfigGroupResponse result(List<MsFieldConfigGroup> result) {
    this.result = result;
    return this;
  }

  public MsFieldConfigGroupResponse addResultItem(MsFieldConfigGroup resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 反馈数据
   * @return result
  **/
  @ApiModelProperty(value = "反馈数据")
  public List<MsFieldConfigGroup> getResult() {
    return result;
  }

  public void setResult(List<MsFieldConfigGroup> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFieldConfigGroupResponse fieldConfigGroupResponse = (MsFieldConfigGroupResponse) o;
    return Objects.equals(this.code, fieldConfigGroupResponse.code) &&
        Objects.equals(this.message, fieldConfigGroupResponse.message) &&
        Objects.equals(this.result, fieldConfigGroupResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFieldConfigGroupResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
