package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsFieldConfigGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 反馈结果
 */
@ApiModel(description = "反馈结果")

@JsonInclude(NON_NULL)
public class MsFieldConfigGroupResult {
  @JsonProperty("fieldConfigGroupList")
  private List<MsFieldConfigGroup> fieldConfigGroupList = new ArrayList<MsFieldConfigGroup>();

  @JsonIgnore
  public MsFieldConfigGroupResult fieldConfigGroupList(List<MsFieldConfigGroup> fieldConfigGroupList) {
    this.fieldConfigGroupList = fieldConfigGroupList;
    return this;
  }

  public MsFieldConfigGroupResult addFieldConfigGroupListItem(MsFieldConfigGroup fieldConfigGroupListItem) {
    this.fieldConfigGroupList.add(fieldConfigGroupListItem);
    return this;
  }

   /**
   * 租户维度配置字段集合
   * @return fieldConfigGroupList
  **/
  @ApiModelProperty(value = "租户维度配置字段集合")
  public List<MsFieldConfigGroup> getFieldConfigGroupList() {
    return fieldConfigGroupList;
  }

  public void setFieldConfigGroupList(List<MsFieldConfigGroup> fieldConfigGroupList) {
    this.fieldConfigGroupList = fieldConfigGroupList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFieldConfigGroupResult fieldConfigGroupResult = (MsFieldConfigGroupResult) o;
    return Objects.equals(this.fieldConfigGroupList, fieldConfigGroupResult.fieldConfigGroupList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldConfigGroupList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFieldConfigGroupResult {\n");
    
    sb.append("    fieldConfigGroupList: ").append(toIndentedString(fieldConfigGroupList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
