package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsInvoiceFilter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 筛选条件请求对象
 */
@ApiModel(description = "筛选条件请求对象")

@JsonInclude(NON_NULL)
public class MsFilterConditionInfoRequest {
  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("controlList")
  private List<MsInvoiceFilter> controlList = new ArrayList<MsInvoiceFilter>();

  @JsonIgnore
  public MsFilterConditionInfoRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 组id
   * @return groupId
  **/
  @ApiModelProperty(value = "组id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsFilterConditionInfoRequest controlList(List<MsInvoiceFilter> controlList) {
    this.controlList = controlList;
    return this;
  }

  public MsFilterConditionInfoRequest addControlListItem(MsInvoiceFilter controlListItem) {
    this.controlList.add(controlListItem);
    return this;
  }

   /**
   * 控件数据
   * @return controlList
  **/
  @ApiModelProperty(value = "控件数据")
  public List<MsInvoiceFilter> getControlList() {
    return controlList;
  }

  public void setControlList(List<MsInvoiceFilter> controlList) {
    this.controlList = controlList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFilterConditionInfoRequest filterConditionInfoRequest = (MsFilterConditionInfoRequest) o;
    return Objects.equals(this.groupId, filterConditionInfoRequest.groupId) &&
        Objects.equals(this.controlList, filterConditionInfoRequest.controlList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, controlList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFilterConditionInfoRequest {\n");
    
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    controlList: ").append(toIndentedString(controlList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
