package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsInvoiceFilter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 筛选器组对象
 */
@ApiModel(description = "筛选器组对象")

@JsonInclude(NON_NULL)
public class MsFilterGroup {
  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("groupName")
  private String groupName = null;

  @JsonProperty("orderNum")
  private Integer orderNum = null;

  @JsonProperty("checked")
  private Boolean checked = null;

  @JsonProperty("list")
  private List<MsInvoiceFilter> list = new ArrayList<MsInvoiceFilter>();

  @JsonIgnore
  public MsFilterGroup groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 组id
   * @return groupId
  **/
  @ApiModelProperty(value = "组id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsFilterGroup groupName(String groupName) {
    this.groupName = groupName;
    return this;
  }

   /**
   * 组名
   * @return groupName
  **/
  @ApiModelProperty(value = "组名")
  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  @JsonIgnore
  public MsFilterGroup orderNum(Integer orderNum) {
    this.orderNum = orderNum;
    return this;
  }

   /**
   * 排序
   * @return orderNum
  **/
  @ApiModelProperty(value = "排序")
  public Integer getOrderNum() {
    return orderNum;
  }

  public void setOrderNum(Integer orderNum) {
    this.orderNum = orderNum;
  }

  @JsonIgnore
  public MsFilterGroup checked(Boolean checked) {
    this.checked = checked;
    return this;
  }

   /**
   * 是否选中
   * @return checked
  **/
  @ApiModelProperty(value = "是否选中")
  public Boolean getChecked() {
    return checked;
  }

  public void setChecked(Boolean checked) {
    this.checked = checked;
  }

  @JsonIgnore
  public MsFilterGroup list(List<MsInvoiceFilter> list) {
    this.list = list;
    return this;
  }

  public MsFilterGroup addListItem(MsInvoiceFilter listItem) {
    this.list.add(listItem);
    return this;
  }

   /**
   * Get list
   * @return list
  **/
  @ApiModelProperty(value = "")
  public List<MsInvoiceFilter> getList() {
    return list;
  }

  public void setList(List<MsInvoiceFilter> list) {
    this.list = list;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFilterGroup filterGroup = (MsFilterGroup) o;
    return Objects.equals(this.groupId, filterGroup.groupId) &&
        Objects.equals(this.groupName, filterGroup.groupName) &&
        Objects.equals(this.orderNum, filterGroup.orderNum) &&
        Objects.equals(this.checked, filterGroup.checked) &&
        Objects.equals(this.list, filterGroup.list);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, groupName, orderNum, checked, list);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFilterGroup {\n");
    
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    orderNum: ").append(toIndentedString(orderNum)).append("\n");
    sb.append("    checked: ").append(toIndentedString(checked)).append("\n");
    sb.append("    list: ").append(toIndentedString(list)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
