package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 编辑筛选组对象
 */
@ApiModel(description = "编辑筛选组对象")

@JsonInclude(NON_NULL)
public class MsFilterGroupInfoRequest {
  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("groupName")
  private String groupName = null;

  @JsonProperty("orderNum")
  private Integer orderNum = null;

  @JsonIgnore
  public MsFilterGroupInfoRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 组id
   * @return groupId
  **/
  @ApiModelProperty(value = "组id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsFilterGroupInfoRequest groupName(String groupName) {
    this.groupName = groupName;
    return this;
  }

   /**
   * 组名
   * @return groupName
  **/
  @ApiModelProperty(value = "组名")
  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  @JsonIgnore
  public MsFilterGroupInfoRequest orderNum(Integer orderNum) {
    this.orderNum = orderNum;
    return this;
  }

   /**
   * 排序
   * @return orderNum
  **/
  @ApiModelProperty(value = "排序")
  public Integer getOrderNum() {
    return orderNum;
  }

  public void setOrderNum(Integer orderNum) {
    this.orderNum = orderNum;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFilterGroupInfoRequest filterGroupInfoRequest = (MsFilterGroupInfoRequest) o;
    return Objects.equals(this.groupId, filterGroupInfoRequest.groupId) &&
        Objects.equals(this.groupName, filterGroupInfoRequest.groupName) &&
        Objects.equals(this.orderNum, filterGroupInfoRequest.orderNum);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, groupName, orderNum);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFilterGroupInfoRequest {\n");
    
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    orderNum: ").append(toIndentedString(orderNum)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
