package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 已选筛选组请求对象
 */
@ApiModel(description = "已选筛选组请求对象")

@JsonInclude(NON_NULL)
public class MsFilterGroupRequest {
  @JsonProperty("resourceType")
  private Integer resourceType = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("userName")
  private String userName = null;

  @JsonIgnore
  public MsFilterGroupRequest resourceType(Integer resourceType) {
    this.resourceType = resourceType;
    return this;
  }

   /**
   * 页面类型：1-发票管理；2-发票认证
   * @return resourceType
  **/
  @ApiModelProperty(value = "页面类型：1-发票管理；2-发票认证")
  public Integer getResourceType() {
    return resourceType;
  }

  public void setResourceType(Integer resourceType) {
    this.resourceType = resourceType;
  }

  @JsonIgnore
  public MsFilterGroupRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 所属用户id
   * @return userId
  **/
  @ApiModelProperty(value = "所属用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsFilterGroupRequest userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * 所属用户名
   * @return userName
  **/
  @ApiModelProperty(value = "所属用户名")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFilterGroupRequest filterGroupRequest = (MsFilterGroupRequest) o;
    return Objects.equals(this.resourceType, filterGroupRequest.resourceType) &&
        Objects.equals(this.userId, filterGroupRequest.userId) &&
        Objects.equals(this.userName, filterGroupRequest.userName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceType, userId, userName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFilterGroupRequest {\n");
    
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
