package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询认证封锁回复详细
 */
@ApiModel(description = "查询认证封锁回复详细")

@JsonInclude(NON_NULL)
public class MsFindAuthBlockDetail {
  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("blockRemark")
  private String blockRemark = null;

  @JsonIgnore
  public MsFindAuthBlockDetail groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsFindAuthBlockDetail companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司ID
   * @return companyId
  **/
  @ApiModelProperty(value = "公司ID")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsFindAuthBlockDetail companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsFindAuthBlockDetail status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 封锁状态，1-未封锁，2-已封锁
   * @return status
  **/
  @ApiModelProperty(value = "封锁状态，1-未封锁，2-已封锁")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsFindAuthBlockDetail blockRemark(String blockRemark) {
    this.blockRemark = blockRemark;
    return this;
  }

   /**
   * 封锁备注
   * @return blockRemark
  **/
  @ApiModelProperty(value = "封锁备注")
  public String getBlockRemark() {
    return blockRemark;
  }

  public void setBlockRemark(String blockRemark) {
    this.blockRemark = blockRemark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFindAuthBlockDetail findAuthBlockDetail = (MsFindAuthBlockDetail) o;
    return Objects.equals(this.groupId, findAuthBlockDetail.groupId) &&
        Objects.equals(this.companyId, findAuthBlockDetail.companyId) &&
        Objects.equals(this.companyTaxNo, findAuthBlockDetail.companyTaxNo) &&
        Objects.equals(this.status, findAuthBlockDetail.status) &&
        Objects.equals(this.blockRemark, findAuthBlockDetail.blockRemark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, companyId, companyTaxNo, status, blockRemark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFindAuthBlockDetail {\n");
    
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    blockRemark: ").append(toIndentedString(blockRemark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
