package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询认证限额回复详细
 */
@ApiModel(description = "查询认证限额回复详细")

@JsonInclude(NON_NULL)
public class MsFindAuthQuotaDetail {
  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("quotaMonth")
  private String quotaMonth = null;

  @JsonProperty("quota")
  private String quota = null;

  @JsonIgnore
  public MsFindAuthQuotaDetail groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsFindAuthQuotaDetail companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司ID
   * @return companyId
  **/
  @ApiModelProperty(value = "公司ID")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsFindAuthQuotaDetail companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsFindAuthQuotaDetail quotaMonth(String quotaMonth) {
    this.quotaMonth = quotaMonth;
    return this;
  }

   /**
   * 限额月份
   * @return quotaMonth
  **/
  @ApiModelProperty(value = "限额月份")
  public String getQuotaMonth() {
    return quotaMonth;
  }

  public void setQuotaMonth(String quotaMonth) {
    this.quotaMonth = quotaMonth;
  }

  @JsonIgnore
  public MsFindAuthQuotaDetail quota(String quota) {
    this.quota = quota;
    return this;
  }

   /**
   * 认证限额
   * @return quota
  **/
  @ApiModelProperty(value = "认证限额")
  public String getQuota() {
    return quota;
  }

  public void setQuota(String quota) {
    this.quota = quota;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFindAuthQuotaDetail findAuthQuotaDetail = (MsFindAuthQuotaDetail) o;
    return Objects.equals(this.groupId, findAuthQuotaDetail.groupId) &&
        Objects.equals(this.companyId, findAuthQuotaDetail.companyId) &&
        Objects.equals(this.companyTaxNo, findAuthQuotaDetail.companyTaxNo) &&
        Objects.equals(this.quotaMonth, findAuthQuotaDetail.quotaMonth) &&
        Objects.equals(this.quota, findAuthQuotaDetail.quota);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, companyId, companyTaxNo, quotaMonth, quota);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFindAuthQuotaDetail {\n");
    
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    quotaMonth: ").append(toIndentedString(quotaMonth)).append("\n");
    sb.append("    quota: ").append(toIndentedString(quota)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
