package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 外部获取认证限额入参
 */
@ApiModel(description = "外部获取认证限额入参")

@JsonInclude(NON_NULL)
public class MsFindAuthQuotaPram {
  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("quotaMonth")
  private String quotaMonth = null;

  @JsonIgnore
  public MsFindAuthQuotaPram groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsFindAuthQuotaPram companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司ID
   * @return companyId
  **/
  @ApiModelProperty(value = "公司ID")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsFindAuthQuotaPram companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsFindAuthQuotaPram quotaMonth(String quotaMonth) {
    this.quotaMonth = quotaMonth;
    return this;
  }

   /**
   * 限额月份
   * @return quotaMonth
  **/
  @ApiModelProperty(value = "限额月份")
  public String getQuotaMonth() {
    return quotaMonth;
  }

  public void setQuotaMonth(String quotaMonth) {
    this.quotaMonth = quotaMonth;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFindAuthQuotaPram findAuthQuotaPram = (MsFindAuthQuotaPram) o;
    return Objects.equals(this.groupId, findAuthQuotaPram.groupId) &&
        Objects.equals(this.companyId, findAuthQuotaPram.companyId) &&
        Objects.equals(this.companyTaxNo, findAuthQuotaPram.companyTaxNo) &&
        Objects.equals(this.quotaMonth, findAuthQuotaPram.quotaMonth);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, companyId, companyTaxNo, quotaMonth);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFindAuthQuotaPram {\n");
    
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    quotaMonth: ").append(toIndentedString(quotaMonth)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
