package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsFindAuthQuotaPram;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询认证限额
 */
@ApiModel(description = "查询认证限额")

@JsonInclude(NON_NULL)
public class MsFindAuthQuotaRequest {
  @JsonProperty("findParams")
  private List<MsFindAuthQuotaPram> findParams = new ArrayList<MsFindAuthQuotaPram>();

  @JsonIgnore
  public MsFindAuthQuotaRequest findParams(List<MsFindAuthQuotaPram> findParams) {
    this.findParams = findParams;
    return this;
  }

  public MsFindAuthQuotaRequest addFindParamsItem(MsFindAuthQuotaPram findParamsItem) {
    this.findParams.add(findParamsItem);
    return this;
  }

   /**
   * Get findParams
   * @return findParams
  **/
  @ApiModelProperty(value = "")
  public List<MsFindAuthQuotaPram> getFindParams() {
    return findParams;
  }

  public void setFindParams(List<MsFindAuthQuotaPram> findParams) {
    this.findParams = findParams;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFindAuthQuotaRequest findAuthQuotaRequest = (MsFindAuthQuotaRequest) o;
    return Objects.equals(this.findParams, findAuthQuotaRequest.findParams);
  }

  @Override
  public int hashCode() {
    return Objects.hash(findParams);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFindAuthQuotaRequest {\n");
    
    sb.append("    findParams: ").append(toIndentedString(findParams)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
