package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取发票认证条件的请求
 */
@ApiModel(description = "获取发票认证条件的请求")

@JsonInclude(NON_NULL)
public class MsGetAuthConditionRequest {
  @JsonProperty("groupId")
  private String groupId = null;

  @JsonProperty("purchaserTaxNo")
  private List<String> purchaserTaxNo = new ArrayList<String>();

  @JsonIgnore
  public MsGetAuthConditionRequest groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团Id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团Id")
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsGetAuthConditionRequest purchaserTaxNo(List<String> purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

  public MsGetAuthConditionRequest addPurchaserTaxNoItem(String purchaserTaxNoItem) {
    this.purchaserTaxNo.add(purchaserTaxNoItem);
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public List<String> getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(List<String> purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetAuthConditionRequest getAuthConditionRequest = (MsGetAuthConditionRequest) o;
    return Objects.equals(this.groupId, getAuthConditionRequest.groupId) &&
        Objects.equals(this.purchaserTaxNo, getAuthConditionRequest.purchaserTaxNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, purchaserTaxNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetAuthConditionRequest {\n");
    
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
