package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 认证发送验真的请求
 */
@ApiModel(description = "认证发送验真的请求")

@JsonInclude(NON_NULL)
public class MsGetAuthSendVerifyRequest {
  @JsonProperty("groupId")
  private String groupId = null;

  @JsonProperty("internalOrgId")
  private List<String> internalOrgId = new ArrayList<String>();

  @JsonIgnore
  public MsGetAuthSendVerifyRequest groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团Id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团Id")
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsGetAuthSendVerifyRequest internalOrgId(List<String> internalOrgId) {
    this.internalOrgId = internalOrgId;
    return this;
  }

  public MsGetAuthSendVerifyRequest addInternalOrgIdItem(String internalOrgIdItem) {
    this.internalOrgId.add(internalOrgIdItem);
    return this;
  }

   /**
   * 内部组织Id
   * @return internalOrgId
  **/
  @ApiModelProperty(value = "内部组织Id")
  public List<String> getInternalOrgId() {
    return internalOrgId;
  }

  public void setInternalOrgId(List<String> internalOrgId) {
    this.internalOrgId = internalOrgId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetAuthSendVerifyRequest getAuthSendVerifyRequest = (MsGetAuthSendVerifyRequest) o;
    return Objects.equals(this.groupId, getAuthSendVerifyRequest.groupId) &&
        Objects.equals(this.internalOrgId, getAuthSendVerifyRequest.internalOrgId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, internalOrgId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetAuthSendVerifyRequest {\n");
    
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    internalOrgId: ").append(toIndentedString(internalOrgId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
